% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BORDA.R
\name{apply.BORDA}
\alias{apply.BORDA}
\title{Function to apply BORDA method to data}
\usage{
apply.BORDA(mat, beneficial.vector)
}
\arguments{
\item{mat}{A numeric matrix or data frame. Rows represent alternatives,
columns represent criteria.}

\item{beneficial.vector}{An integer vector containing the column indices of
criteria that are beneficial (profit). All other columns are treated as
non-beneficial (cost).}
}
\value{
A numeric vector of total Borda scores for each alternative, in the
original row order.
}
\description{
This function implements a simple Borda count approach for a decision matrix.
It computes a rank for each criterion and then sums these ranks for each alternative.
By specifying which columns are beneficial (i.e., higher values preferred),
it automatically treats the remaining columns as non-beneficial (i.e., lower values preferred).
}
\examples{
# Create a small decision matrix (4 alternatives x 3 criteria)
mat <- matrix(c(
  5, 9, 2,
  7, 3, 8,
  6, 5, 4,
  4, 7, 9
), nrow = 4, byrow = TRUE)

beneficial.vector <- c(1, 3)


borda_scores <- apply.BORDA(mat, beneficial.vector)
borda_scores
}
