% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRA.R
\name{apply.GRA}
\alias{apply.GRA}
\title{Apply Grey Relational Analysis (GRA) method}
\usage{
apply.GRA(mat, weights, beneficial.vector, epsilon = 0.5)
}
\arguments{
\item{mat}{is a matrix containing the values for different properties
of different alternatives}

\item{weights}{are the weights of each property in the decision-making process}

\item{beneficial.vector}{is a vector containing the column numbers of beneficial
properties. Non-beneficial properties are assumed to be the remaining columns.}

\item{epsilon}{is a parameter for the GRA method, default is 0.5}
}
\value{
a vector containing the calculated GRA scores
}
\description{
Apply Grey Relational Analysis (GRA) method
}
\examples{
mat <- matrix(c(80, 60, 90,
                75, 85, 95,
                70, 65, 85,
                60, 75, 80),
              nrow = 4, byrow = TRUE)
colnames(mat) <- c("Criterion 1", "Criterion 2", "Criterion 3")
weights <- c(0.4, 0.3, 0.3)
beneficial.vector <- c(1, 2, 3)
apply.GRA(mat, weights, beneficial.vector)
}
