% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MABAC.R
\name{apply.MABAC}
\alias{apply.MABAC}
\title{Apply Multi-Attributive Border Approximation Area Comparison (MABAC)}
\usage{
apply.MABAC(mat, weights, types)
}
\arguments{
\item{mat}{A numeric matrix. Rows are alternatives; columns are criteria.}

\item{weights}{A numeric vector of weights corresponding to criteria columns. Must sum to 1.}

\item{types}{An integer vector of the same length as \code{weights}. Use 1 for a profit criterion
and -1 for a cost criterion.}
}
\value{
A numeric vector with the MABAC preference values for each alternative.
A higher value indicates a more preferred alternative.
}
\description{
R implementation of the MABAC method.
The MABAC method computes the distance between each alternative and the
Boundary Approximation Area (BAA), based on a weighted normalized decision matrix.
}
\examples{
# Example usage:
mat <- matrix(c(
  22600, 3800, 2,   5, 1.06, 3.00, 3.5,  2.8, 24.5, 6.5,
  19500, 4200, 3,   2, 0.95, 3.00, 3.4,  2.2, 24.0, 7.0,
  21700, 4000, 1,   3, 1.25, 3.20, 3.3,  2.5, 24.5, 7.3,
  20600, 3800, 2,   5, 1.05, 3.25, 3.2,  2.0, 22.5, 11.0,
  22500, 3800, 4,   3, 1.35, 3.20, 3.7,  2.1, 23.0, 6.3,
  23250, 4210, 3,   5, 1.45, 3.60, 3.5,  2.8, 23.5, 7.0,
  20300, 3850, 2,   5, 0.90, 3.25, 3.0,  2.6, 21.5, 6.0
), nrow = 7, byrow = TRUE)

weights <- c(0.146, 0.144, 0.119, 0.121, 0.115, 0.101, 0.088, 0.068, 0.050, 0.048)
types <- c(-1, 1, 1, 1, -1, -1, 1, 1, 1, 1)

apply.MABAC(mat, weights, types)
}
