% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OPA.R
\name{apply.OPA}
\alias{apply.OPA}
\title{Apply Ordinal Priority Approach (OPA)}
\usage{
apply.OPA(expert.opinion.lst, expert.rank, criterion.rank.lst)
}
\arguments{
\item{expert.opinion.lst}{A list of matrices where each matrix represents the rankings of alternatives
for each criterion as assessed by a particular expert. Each row corresponds
to an alternative, and each column corresponds to a criterion.}

\item{expert.rank}{A numeric vector specifying the rank or weight of importance for each expert.}

\item{criterion.rank.lst}{A list of numeric vectors where each vector represents the rank or weight
of importance for the criteria as assessed by each expert.}
}
\value{
A list of matrices where each matrix represents the optimal weights for the alternatives
and criteria for a specific expert.
}
\description{
This function applies the Ordinal Priority Approach (OPA) to determine the optimal weights
for experts, criteria, and alternatives based on expert opinions, ranks, and criterion importance.
}
\examples{
# Input Data
expert.x.alt <- matrix(c(1, 3, 2, 2, 1, 3), nrow = 3)
colnames(expert.x.alt) <- c("c", "q")
rownames(expert.x.alt) <- c("alt1", "alt2", "alt3")

expert.y.alt <- matrix(c(1, 2, 3, 3, 1, 2), nrow = 3)
colnames(expert.y.alt) <- c("c", "q")
rownames(expert.y.alt) <- c("alt1", "alt2", "alt3")

expert.opinion.lst <- list(expert.x.alt, expert.y.alt)
expert.rank <- c(1, 2)  # Ranks of experts

# Criterion ranks for each expert
criterion.x.rank <- c(1, 2)
criterion.y.rank <- c(2, 1)  # Adjusted criterion rank for expert y
criterion.rank.lst <- list(criterion.x.rank, criterion.y.rank)

# Apply OPA
weights <- apply.OPA(expert.opinion.lst, expert.rank, criterion.rank.lst)

}
