% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIV.R
\name{apply.PIV}
\alias{apply.PIV}
\title{Apply Proximity Indexed Value (PIV) method}
\usage{
apply.PIV(mat, weights, beneficial.vector)
}
\arguments{
\item{mat}{A numeric matrix containing the values for different properties
of different alternatives.}

\item{weights}{A numeric vector containing the weights of each property.}

\item{beneficial.vector}{A numeric vector containing the column indices of beneficial
criteria. Non-beneficial criteria are assumed to be the remaining columns.}
}
\value{
A numeric vector containing the calculated PIV scores for each alternative.
}
\description{
Apply Proximity Indexed Value (PIV) method
}
\examples{
mat <- matrix(c(80, 60, 90,
                75, 85, 95,
                70, 65, 85,
                60, 75, 80),
              nrow = 4, byrow = TRUE)
colnames(mat) <- c("Criterion 1", "Criterion 2", "Criterion 3")
weights <- c(0.4, 0.3, 0.3)
beneficial.vector <- c(1, 2, 3)
apply.PIV(mat, weights, beneficial.vector)
}
