% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_roc.R
\name{summarize_predictor}
\alias{summarize_predictor}
\title{Summarize classifier performance}
\usage{
summarize_predictor(
  data = NULL,
  predictor,
  response,
  ratio,
  threshold,
  .condition = NULL
)
}
\arguments{
\item{data}{A data.frame or extension (e.g. a tibble) containing values for
predictors and response variables.}

\item{predictor}{A data variable which must be numeric, representing values
of a classifier or predictor for each observation.}

\item{response}{A data variable which must be a factor, integer or character
vector representing the prediction outcome on each observation
(\emph{Gold Standard}).

If the variable presents more than two possible outcomes, classes or
categories:
\itemize{
\item The outcome of interest (the one to be predicted) will remain distinct.
\item All other categories will be combined into a single category.
}

New combined category represents the "absence" of the condition to predict.
See \code{.condition} for more information.}

\item{ratio}{Ratio or axis where to apply calculations.
\itemize{
\item If \code{"tpr"}, only points within the specified region of TPR, y axis, will be
considered for calculations.
\item If \code{"fpr"}, only points within the specified region of FPR, x axis, will be
considered for calculations.
}}

\item{threshold}{A number between 0 and 1, both inclusive, which represents
the region bound where to calculate partial area under curve.

If \code{ratio = "tpr"}, it represents lower bound of the TPR region, being its
upper limit equal to 1.

If \code{ratio = "fpr"}, it represents the upper bound of the FPR region,
being its lower limit equal to 0.}

\item{.condition}{A value from response that represents class, category or
condition of interest which wants to be predicted.

If \code{NULL}, condition of interest will be selected automatically depending on
\code{response} type.

Once the class of interest is selected, rest of them will be collapsed in a
common category, representing the "absence" of the condition to be predicted.

See \code{vignette("selecting-condition")} for further information on how
automatic selection is performed and details on selecting the condition of
interest.}
}
\value{
A single row tibble with different predictor with following metrics as
columns:
\itemize{
\item Area under curve (AUC) as a metric of global performance.
\item Partial are under curve (pAUC) as a metric of local performance.
\item Indexes derived from pAUC, depending on the selected ratio.
\link[=sensitivity_indexes]{Sensitivity indexes} will be used for
TPR and \link[=specificity_indexes]{specificity indexes} for FPR.
\item \link[=calc_curve_shape]{Curve shape} in the specified region.
}
}
\description{
Calculates a series of metrics describing global and local
classifier performance.
}
\examples{
# Summarize Sepal.Width as a classifier of setosa species
# and local performance in TPR (0.9, 1)
summarize_predictor(
 data = iris,
 predictor = Sepal.Width,
 response = Species,
 ratio = "tpr",
 threshold = 0.9
)
# Summarize Sepal.Width as a classifier of setosa species
# and local performance in FPR (0, 0.1)
summarize_predictor(
 data = iris,
 predictor = Sepal.Width,
 response = Species,
 ratio = "fpr",
 threshold = 0.1
)
}
