% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROKET.R
\name{run_myOTs}
\alias{run_myOTs}
\title{run_myOTs}
\usage{
run_myOTs(
  ZZ,
  COST,
  EPS,
  LAMBDA1,
  LAMBDA2 = NULL,
  balance,
  conv = 1e-05,
  max_iter = 3000,
  ncores = 1,
  verbose = TRUE,
  show_iter = 50
)
}
\arguments{
\item{ZZ}{A numeric matrix of non-negative mass to transport.
Rows correspond to features (e.g. genes) and columns
correspond to samples or individuals. Each column must have
strictly positive mass}

\item{COST}{A numeric square matrix of non-negative values
representing the non-negative costs to transport 
masses between pairs of features}

\item{EPS}{A positive numeric value representing the
tuning parameter for entropic regularization.}

\item{LAMBDA1}{A non-negative numeric value representing
the tuning parameter penalizing the distance between \code{XX}
and the row sums of the optimal transport matrix.}

\item{LAMBDA2}{A non-negative numeric value representing
the tuning parameter penalizing the distance between \code{YY}
and the column sums of the optimal transport matrix.}

\item{balance}{Boolean set to \code{TRUE} to run balanced
optimal transport regardless of LAMDA1 and LAMBDA2. 
Otherwise run unbalanced optimal transport.}

\item{conv}{A positive numeric value to determine 
algorithmic convergence. The default value is \code{1e-5}.}

\item{max_iter}{A positive integer denoting the maximum
iterations to run the algorithm.}

\item{ncores}{A positive integer for the number of cores/threads
to reduce computational runtime when running for loops}

\item{verbose}{Boolean value to display verbose function output.}

\item{show_iter}{A positive integer to display iteration details
at multiples of \code{show_iter} but only if \code{verbose = TRUE}.}
}
\value{
A R numeric matrix of pairwise distances.
}
\description{
run_myOTs
}
