% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{pbSetup}
\alias{pbSetup}
\title{Create a JSON config file}
\usage{
pbSetup(apikey, conffile, defdev)
}
\arguments{
\item{apikey}{An \emph{Access Token} provided by Pushbullet (see details). If not
provided in the function call, the user will be prompted to enter one.}

\item{conffile}{A string giving the path where the configuration file will
be written. RPushbullet will automatically attempt load from the default location
\code{~/.rpushbullet.json} (which can be changed via a \code{rpushbullet.dotfile})
entry in \code{options}).}

\item{defdev}{An optional value for the default device; if missing (or \code{NA})
then an interactive prompt is used.}
}
\value{
\code{NULL} is returned invisibly, but the function is called for its side
effect of creating the configuration file.
}
\description{
Create a JSON config file
}
\details{
This function writes a simple default configuration file based
on a given apikey.  It is intended to be run once to help new users setup
RPushbullet. Running multiple times without overriding the
\code{config_file} parameter will overwrite the default file. An \emph{Access
Token} may be obtained for free by logging into the Pushbullet website,
going to \url{https://www.pushbullet.com/#settings}, and clicking on
"Create Access Token".
}
\examples{
\dontrun{
# Interactive mode.  Just follow the prompts.
pbSetup()
}
}
\author{
Seth Wenchel and Dirk Eddelbuettel
}
