% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Boost.R
\name{cal_predict}
\alias{cal_predict}
\title{cal_predict}
\usage{
cal_predict(model, x_test, y_test)
}
\arguments{
\item{model}{an object returned by Boost}

\item{x_test}{predictor matrix for test data (matrix/dataframe)}

\item{y_test}{response vector for test data (vector/dataframe)}
}
\value{
A list with with the following components:

\item{f_t_test}{predicted values with model at the early stopping iteration using x_test as the predictors}
\item{err_test}{a matrix of test errors before and at the early stopping iteration (returned if make_prediction = TRUE in control); the matrix dimension is the early stopping iteration by the number of error types (matches the \code{error} argument in the input); each row corresponds to the test errors at each iteration}
\item{f_test}{a matrix of test function estimates at all iterations (returned if save_f = TRUE in control)}
\item{value}{a vector of test errors evaluated at the early stopping iteration}
}
\description{
A function to make predictions and calculate test error given an object returned by Boost and test data
}
\details{
A function to make predictions and calculate test error given an object returned by Boost and test data
}
\examples{
\dontrun{
data(airfoil)
n <- nrow(airfoil)
n0 <- floor( 0.2 * n )
set.seed(123)
idx_test <- sample(n, n0)
idx_train <- sample((1:n)[-idx_test], floor( 0.6 * n ) )
idx_val <- (1:n)[ -c(idx_test, idx_train) ]
xx <- airfoil[, -6]
yy <- airfoil$y
xtrain <- xx[ idx_train, ]
ytrain <- yy[ idx_train ]
xval <- xx[ idx_val, ]
yval <- yy[ idx_val ]
xtest <- xx[ idx_test, ]
ytest <- yy[ idx_test ]
model = Boost(x_train = xtrain, y_train = ytrain,
     x_val = xval, y_val = yval,
     type = "RRBoost", error = "rmse",
     y_init = "LADTree", max_depth = 1, niter = 1000,
     control = Boost.control(max_depth_init = 2,
           min_leaf_size_init = 10, save_tree = TRUE,
           make_prediction =  FALSE, cal_imp = FALSE))
prediction <- cal_predict(model, x_test = xtest, y_test = ytest)
}

}
\author{
Xiaomeng Ju, \email{xiaomeng.ju@stat.ubc.ca}
}
