% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql-lib.R
\name{RSQL.class}
\alias{RSQL.class}
\title{The class that provides the SQL functionality.}
\description{
This class is intended to simplify SQL commands.
}
\examples{
library(RSQL)
library(RSQLite)
db.name <- getMtcarsdbPath(copy = TRUE)
rsql <- createRSQL(drv = RSQLite::SQLite(), dbname = db.name)
select_sql <- rsql$gen_select(
  select_fields = "*", # c("wt", "qsec"),
  table = "mtcars",
  where_values = data.frame(carb = 8)
)
mtcars.observed <- rsql$execute_select(select_sql)
mtcars.observed

mtcars.new <- mtcars.observed
mtcars.new$carb <- 9
insert_sql <- rsql$gen_insert(table = "mtcars", values_df = mtcars.new)
rsql$execute_insert(sql_insert = insert_sql)

where_values_df <- data.frame(carb = 9)
select_sql <- rsql$gen_select(
  select_fields = "*", # c("wt", "qsec"),
  table = "mtcars",
  where_values = data.frame(carb = 8)
)
mtcars.observed <- rsql$execute_select(select_sql)
mtcars.observed
}
\author{
ken4rab
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{driver}}{driver  name}

\item{\code{db.name}}{database name}

\item{\code{user}}{db user}

\item{\code{password}}{db password}

\item{\code{host}}{db host}

\item{\code{port}}{db port}

\item{\code{available.functions}}{for generating select expressions}

\item{\code{entity.field.regexp}}{for scrape a field or table expression}

\item{\code{entity.select.regexp}}{for scrape a select expressions expression}

\item{\code{conn}}{The connection handler}

\item{\code{valid.conn}}{Checks if connection is valid}

\item{\code{last.query}}{The last query}

\item{\code{last.rs}}{The last resultset}

\item{\code{results.class}}{Expected class for db results for running dbClearResult}

\item{\code{select.counter}}{An instance select counter}

\item{\code{insert.counter}}{An instance insert counter}

\item{\code{update.counter}}{An instance update counter}

\item{\code{delete.counter}}{An instance delete counter}

\item{\code{command.counter}}{An instance command counter}

\item{\code{clear.rs.counter}}{An instance clear.rs.counter}

\item{\code{tz}}{local timezone}

\item{\code{logger}}{is conigured logger for current class}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RSQL-new}{\code{RSQL.class$new()}}
\item \href{#method-RSQL-checkConnection}{\code{RSQL.class$checkConnection()}}
\item \href{#method-RSQL-connect}{\code{RSQL.class$connect()}}
\item \href{#method-RSQL-setupResultClassFromDriver}{\code{RSQL.class$setupResultClassFromDriver()}}
\item \href{#method-RSQL-setupRegexp}{\code{RSQL.class$setupRegexp()}}
\item \href{#method-RSQL-finalize}{\code{RSQL.class$finalize()}}
\item \href{#method-RSQL-checkEntitiesNames}{\code{RSQL.class$checkEntitiesNames()}}
\item \href{#method-RSQL-gen_select}{\code{RSQL.class$gen_select()}}
\item \href{#method-RSQL-gen_insert}{\code{RSQL.class$gen_insert()}}
\item \href{#method-RSQL-gen_update}{\code{RSQL.class$gen_update()}}
\item \href{#method-RSQL-gen_delete}{\code{RSQL.class$gen_delete()}}
\item \href{#method-RSQL-execute_select}{\code{RSQL.class$execute_select()}}
\item \href{#method-RSQL-execute_update}{\code{RSQL.class$execute_update()}}
\item \href{#method-RSQL-execute_insert}{\code{RSQL.class$execute_insert()}}
\item \href{#method-RSQL-execute_get_insert}{\code{RSQL.class$execute_get_insert()}}
\item \href{#method-RSQL-execute_command}{\code{RSQL.class$execute_command()}}
\item \href{#method-RSQL-execute_delete}{\code{RSQL.class$execute_delete()}}
\item \href{#method-RSQL-retrieve}{\code{RSQL.class$retrieve()}}
\item \href{#method-RSQL-retrieve_insert}{\code{RSQL.class$retrieve_insert()}}
\item \href{#method-RSQL-clearLastResult}{\code{RSQL.class$clearLastResult()}}
\item \href{#method-RSQL-getSummary}{\code{RSQL.class$getSummary()}}
\item \href{#method-RSQL-disconnect}{\code{RSQL.class$disconnect()}}
\item \href{#method-RSQL-clone}{\code{RSQL.class$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-new"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-new}{}}}
\subsection{Method \code{new()}}{
Initializes a connection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$new(
  drv,
  dbname,
  user = NULL,
  password = NULL,
  host = NULL,
  port = NULL,
  tz = Sys.timezone()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{drv}}{driver name}

\item{\code{dbname}}{database name}

\item{\code{user}}{user name}

\item{\code{password}}{password}

\item{\code{host}}{host name}

\item{\code{port}}{port number}

\item{\code{tz}}{actual time zone}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-checkConnection"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-checkConnection}{}}}
\subsection{Method \code{checkConnection()}}{
Function which check if db connection is valid
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$checkConnection()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
conn object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-connect"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-connect}{}}}
\subsection{Method \code{connect()}}{
Function which connects to database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$connect()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
conn object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-setupResultClassFromDriver"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-setupResultClassFromDriver}{}}}
\subsection{Method \code{setupResultClassFromDriver()}}{
Infer ResultsClass from corresponding driver. Implemented for SQLiteDriver & PqConnection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$setupResultClassFromDriver()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
RSQL object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-setupRegexp"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-setupRegexp}{}}}
\subsection{Method \code{setupRegexp()}}{
initialize regexp for scraping entities
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$setupRegexp(force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{force}}{force setup?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
regexp for scraping select expressions
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-finalize}{}}}
\subsection{Method \code{finalize()}}{
Class destructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-checkEntitiesNames"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-checkEntitiesNames}{}}}
\subsection{Method \code{checkEntitiesNames()}}{
Checks if an entity exists
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$checkEntitiesNames(entities, entity.type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entities}}{entities to check}

\item{\code{entity.type}}{entity type to check against}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-gen_select"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-gen_select}{}}}
\subsection{Method \code{gen_select()}}{
Generates a select
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$gen_select(
  select_fields,
  table,
  where_fields = names(where_values),
  where_values = NULL,
  group_by = c(),
  order_by = c(),
  top = 0,
  distinct = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{select_fields}}{fields to be selected}

\item{\code{table}}{table to select from}

\item{\code{where_fields}}{fields in the where clause}

\item{\code{where_values}}{values to the fields on the where clause}

\item{\code{group_by}}{fields to group by}

\item{\code{order_by}}{fields to order by}

\item{\code{top}}{where does the resultset starts?}

\item{\code{distinct}}{provides a way to select distinct rows}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-gen_insert"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-gen_insert}{}}}
\subsection{Method \code{gen_insert()}}{
Generate  insert statement
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$gen_insert(table, values_df, insert_fields = names(values_df))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{table}}{The table to insert into}

\item{\code{values_df}}{The values to insert. Must be defined as data.frame of values}

\item{\code{insert_fields}}{the fields to insert into}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-gen_update"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-gen_update}{}}}
\subsection{Method \code{gen_update()}}{
Generate  insert statement
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$gen_update(
  table,
  update_fields = names(values),
  values,
  where_fields = names(where_values),
  where_values = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{table}}{the table to insert into}

\item{\code{update_fields}}{the fields to update}

\item{\code{values}}{the values to update}

\item{\code{where_fields}}{a where clause to the insert}

\item{\code{where_values}}{the values to add to the where clause}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-gen_delete"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-gen_delete}{}}}
\subsection{Method \code{gen_delete()}}{
Generate a delete statement
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$gen_delete(
  table,
  where_fields = names(where_values),
  where_values = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{table}}{the table to insert into}

\item{\code{where_fields}}{a where clause to the insert}

\item{\code{where_values}}{the fields to add to the where clause}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-execute_select"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-execute_select}{}}}
\subsection{Method \code{execute_select()}}{
Performs an execution on the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$execute_select(sql_select)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql_select}}{the sql select statement to perform}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-execute_update"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-execute_update}{}}}
\subsection{Method \code{execute_update()}}{
Performs an update on the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$execute_update(sql_update)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql_update}}{the sql update statement to perform}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-execute_insert"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-execute_insert}{}}}
\subsection{Method \code{execute_insert()}}{
Performs an insert on the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$execute_insert(sql_insert)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql_insert}}{the sql insert statement to perform}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-execute_get_insert"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-execute_get_insert}{}}}
\subsection{Method \code{execute_get_insert()}}{
Performs a select statement, if not exists, executes insert statement
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$execute_get_insert(sql_select, sql_insert)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql_select}}{the sql select statement to perform}

\item{\code{sql_insert}}{the sql insert statement to perform}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-execute_command"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-execute_command}{}}}
\subsection{Method \code{execute_command()}}{
Performs a command on the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$execute_command(sql_command)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql_command}}{the sql statement to perform}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-execute_delete"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-execute_delete}{}}}
\subsection{Method \code{execute_delete()}}{
Performs an deletion on the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$execute_delete(sql_delete)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql_delete}}{the sql delete statement to perform}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-retrieve}{}}}
\subsection{Method \code{retrieve()}}{
Performs an insert on the database. This is a composite function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$retrieve(
  table,
  fields_uk = names(values_uk),
  values_uk,
  fields = names(values),
  values = NULL,
  field_id = "id"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{table}}{The table}

\item{\code{fields_uk}}{The fields unique key}

\item{\code{values_uk}}{The values unique key}

\item{\code{fields}}{The fields (Not used. Included for compatibility)}

\item{\code{values}}{The values (Not used. Included for compatibility)}

\item{\code{field_id}}{The field of the serial id}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-retrieve_insert"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-retrieve_insert}{}}}
\subsection{Method \code{retrieve_insert()}}{
Obtain id if object exists on the database. Insert object if not.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$retrieve_insert(
  table,
  fields_uk = names(values_uk),
  values_uk,
  fields = names(values),
  values = data.frame(),
  field_id = "id"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{table}}{The table}

\item{\code{fields_uk}}{The fields unique key}

\item{\code{values_uk}}{The values unique key}

\item{\code{fields}}{The fields}

\item{\code{values}}{The values}

\item{\code{field_id}}{The field of the serial id}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-clearLastResult"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-clearLastResult}{}}}
\subsection{Method \code{clearLastResult()}}{
clearLast Result for avoiding nasty warning
getSummary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$clearLastResult()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-getSummary"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-getSummary}{}}}
\subsection{Method \code{getSummary()}}{
get RSQL summary string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$getSummary()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-disconnect"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-disconnect}{}}}
\subsection{Method \code{disconnect()}}{
Disconnects the instance from the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$disconnect()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RSQL-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RSQL-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
