% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/td.R
\name{td_upload}
\alias{td_upload}
\title{Upload data.frame to TD}
\usage{
td_upload(
  conn,
  dbname,
  table,
  df,
  mode = "bulk_import",
  embulk_dir,
  overwrite = FALSE,
  append = FALSE
)
}
\arguments{
\item{conn}{\code{Td} connection}

\item{dbname}{Target destination database name.}

\item{table}{Target table name.}

\item{df}{Input data.frame.}

\item{mode}{Write mode. "bulk_import" or "embulk". Default: "bulk_import"}

\item{embulk_dir}{Path to embulk. [optional]}

\item{overwrite}{Flag for overwriting the table if exists. It doesn't overwrite database. This flag sets "replace" mode for embulk-output-td.}

\item{append}{Flag for append data into the table if exists. It doesn't overwrite database. This flag sets "append" mode for embulk-output-td.}
}
\description{
Upload data.frame to TD
}
\examples{
\dontrun{
td_upload_embulk("mydb", "iris", iris)

# With overwrite option
td_upload_embulk("mydb", "iris", iris, overwrite = TRUE)

# With append option
td_upload_embulk("mydb", "iris", iris, append = TRUE)

# With overwrite option
td_upload_embulk("mydb", "iris", iris, "/path/to/embulk", overwrite = TRUE)
}

}
