% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_eia_steo.R
\name{chart_eia_steo}
\alias{chart_eia_steo}
\title{EIA Short Term Energy Outlook}
\usage{
chart_eia_steo(
  market = "globalOil",
  key = "your EIA.gov API key",
  from = "2018-07-01",
  fig.title = "EIA STEO Global Liquids SD Balance",
  fig.units = "million barrels per day",
  legend.pos = list(x = 0.4, y = 0.53),
  output = "chart"
)
}
\arguments{
\item{market}{"globalOil" only currently implemented. \code{character}}

\item{key}{Your private EIA API token. \code{character}}

\item{from}{Date as character "2020-07-01". Default to all dates available. \code{character}}

\item{fig.title}{Defaults to "EIA STEO Global Liquids SD Balance". \code{character}}

\item{fig.units}{Defaults to "million barrels per day" \code{character}}

\item{legend.pos}{Defaults to list(x = 0.4, y = 0.53)  \code{list}}

\item{output}{"chart" for plotly object or "data" for dataframe.}
}
\value{
A plotly chart \code{htmlwidget} or a \code{tibble}.
}
\description{
Extract data and either plots or renders dataframe.
}
\examples{
\dontrun{
chart_eia_steo(key = EIAkey, market = "globalOil")
}

}
\author{
Philippe Cote
}
