% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{processString}
\alias{processString}
\title{Process a String}
\usage{
processString(input, processor = TRUE, asciify = FALSE)
}
\arguments{
\item{input}{A \code{std::string} representing the input string to be processed.}

\item{processor}{A \code{bool} indicating whether to trim whitespace and convert the string to lowercase. Default is \code{true}.}

\item{asciify}{A \code{bool} indicating whether to transliterate non-ASCII characters to their closest ASCII equivalents. Default is \code{false}.}
}
\value{
A \code{std::string} representing the processed string.
}
\description{
Processes a given input string by applying optional trimming, case conversion, and ASCII transliteration.
}
\details{
The function applies the following transformations to the input string, in this order:
\itemize{
  \item \strong{Trimming (if \code{processor = TRUE}):} Removes leading and trailing whitespace.
  \item \strong{Lowercasing (if \code{processor = TRUE}):} Converts all characters to lowercase.
  \item \strong{ASCII Transliteration (if \code{asciify = TRUE}):} Replaces accented or special characters with their closest ASCII equivalents.
}
}
\examples{
# Example usage
processString("  Éxâmple!  ", processor = TRUE, asciify = TRUE)
# Returns: "example!"

processString("  Éxâmple!  ", processor = TRUE, asciify = FALSE)
# Returns: "éxâmple!"

processString("  Éxâmple!  ", processor = FALSE, asciify = TRUE)
# Returns: "Éxâmple!"

processString("  Éxâmple!  ", processor = FALSE, asciify = FALSE)
# Returns: "  Éxâmple!  "
}
