% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tscope.fit.R
\name{tscope.fit}
\alias{tscope.fit}
\title{tscope.fit: Fitter Function for 2sCOPE}
\usage{
tscope.fit(formula, data)
}
\arguments{
\item{formula}{a formula describing the model to be fitted. The details of model specification are given under ``Details''.}

\item{data}{a data frame, list, or environment containing the variables in the model.}
}
\value{
A numeric vector containing the coefficients of the original and generated regressors, including any high-order or interaction terms if present.
}
\description{
Basic computing engine called by \code{tscope()}
}
\details{
The \code{formula} argument is either in the 1-bar form \code{Y ~ X | P} or the 2-bar form \code{Y ~ X | P | W}, where
\code{X} respresents the explanatory variable(s) in the \code{Y} model, \code{P} represents the continuous
endogenous regressors, and \code{W} represents the exogenous regressors.  If \code{X} contains no
exogenous regressors, then the 2sCOPE model reduces to the simpler model in Park and Gupta (2012)
and returns \eqn{P^*} (the copula transformation of \code{P}) as CCF and \eqn{W^*} (the copula transformation of \code{W}) as null.
When the structural outcome model includes an intercept, copula transformations of regressors in \code{P} and \code{W}  use the
optimized algorithm (Equation 9 in Qian, Koschmann, and Xie, 2025)  to avoid estimation bias.

The function will add copula control function for each endogenous regressor specified in \code{P}.
Only first-order terms of endogenous regressors need to be included in \code{P}, even when the structural outcome model
contains higher-order terms of endogenous regressors. This is because including copula control functions for the
first-order endogenous regressors is sufficient to control for endogeneity, while adding control functions for
higher-order endogenous terms---such as interactions among endogenous regressors, interactions between endogenous and
exogenous regressors, or squared endogenous regressors---is unnecessary and can substantially degrade the performance
of copula correction (Qian, Koschmann, and Xie, 2025). This parsimonious treatment of higher-order endogenous
regressors is a merit of copula correction.

Thus, if \code{X} contains no higher-order terms of endogenous regressors, the simpler 1-bar form \code{Y ~ X | P}
can be used, and \code{tscope()} treats all regressors in \code{X} except those in \code{P} as exogenous.
When \code{X} includes higher-order endogenous terms, the 2-bar form  \code{Y ~ X | P | W} should be used to explicitly specify
the exogenous regressors in \code{W} and ensure that the higher-order endogenous terms are not treated as exogenous variables.
}
\examples{

data("diapers") #load data

# run a OLS model to compare results to 2sCOPE
ols <- lm(logVol ~ logPrice+Fshare+week+Q2+Q3+Q4, data = diapers)
coef(ols)

tscope_model_1bar <- tscope.fit(logVol ~ logPrice+Fshare+week+Q2+Q3+Q4|
logPrice, data = diapers) # run 2sCOPE with 1-bar option
tscope_model_1bar

tscope_model_2bar <- tscope.fit(logVol ~ logPrice+Fshare+week+Q2+Q3+Q4|
logPrice|Fshare+week+Q2+Q3+Q4, data = diapers) # run 2sCOPE with 2-bar option
tscope_model_2bar

# notice how both the 1-bar and 2-bar options produce the same parameter
# estimates, and that the results differ from OLS after correcting for endogeneity.

#run Park and Gupta (2012) model
pg <- tscope.fit(logVol ~ logPrice|logPrice, data = diapers)
pg

}
\references{
Qian, Y., Koschmann, A., & Xie, H. (2025).
\emph{EXPRESS: A Practical Guide to Endogeneity Correction Using Copulas.}
Journal of Marketing. \url{doi:10.1177/00222429251410844}\cr

Park, S., & Gupta, S. (2012).
\emph{Handling endogenous regressors by joint estimation using copulas.}
Marketing Science, 31(4), 567-586.\cr

Yang, F., Qian, Y., & Xie, H. (2025).
\emph{Addressing Endogeneity Using a Two-Stage Copula Generated Regressor Approach.}
Journal of Marketing Research, 62(4), 601-623.
\url{doi:10.1177/00222437241296453}\cr
}
