% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-TreeSequence.R
\name{TreeSequence}
\alias{TreeSequence}
\title{Succinct tree sequence R6 class (TreeSequence)}
\description{
An R6 class holding an external pointer to a tree sequence
object. As an R6 class, its methods look Pythonic and therefore resemble the
tskit Python API. Since the class only holds the pointer, it is lightweight.
Currently there is a limited set of R methods for working with the tree sequence.
}
\examples{

## ------------------------------------------------
## Method `TreeSequence$new`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- TreeSequence$new(file = ts_file)
is(ts)
ts
ts$num_nodes()
# Also
ts <- ts_load(ts_file)
is(ts)

## ------------------------------------------------
## Method `TreeSequence$dump`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
dump_file <- tempfile()
ts$dump(dump_file)
ts$write(dump_file) # alias
\dontshow{file.remove(dump_file)}

## ------------------------------------------------
## Method `TreeSequence$dump_tables`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
tc <- ts$dump_tables()
is(tc)

## ------------------------------------------------
## Method `TreeSequence$print`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$print()
ts

## ------------------------------------------------
## Method `TreeSequence$r_to_py`
## ------------------------------------------------

\dontrun{
  ts_file <- system.file("examples/test.trees", package = "RcppTskit")
  ts_r <- ts_load(ts_file)
  is(ts_r)
  ts_r$num_individuals() # 8

  # Transfer the tree sequence to reticulate Python and use tskit Python API
  tskit <- get_tskit_py()
  if (check_tskit_py(tskit)) {
    ts_py <- ts_r$r_to_py()
    is(ts_py)
    ts_py$num_individuals # 8
    ts2_py <- ts_py$simplify(samples = c(0L, 1L, 2L, 3L))
    ts_py$num_individuals # 8
    ts2_py$num_individuals # 2
    ts2_py$num_nodes # 8
    ts2_py$tables$nodes$time # 0.0 ... 5.0093910
  }
}

## ------------------------------------------------
## Method `TreeSequence$num_provenances`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_provenances()

## ------------------------------------------------
## Method `TreeSequence$num_populations`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_populations()

## ------------------------------------------------
## Method `TreeSequence$num_migrations`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_migrations()

## ------------------------------------------------
## Method `TreeSequence$num_individuals`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_individuals()

## ------------------------------------------------
## Method `TreeSequence$num_samples`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_samples()

## ------------------------------------------------
## Method `TreeSequence$num_nodes`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_nodes()

## ------------------------------------------------
## Method `TreeSequence$num_edges`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_edges()

## ------------------------------------------------
## Method `TreeSequence$num_trees`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_trees()

## ------------------------------------------------
## Method `TreeSequence$num_sites`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_sites()

## ------------------------------------------------
## Method `TreeSequence$num_mutations`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_mutations()

## ------------------------------------------------
## Method `TreeSequence$sequence_length`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$sequence_length()

## ------------------------------------------------
## Method `TreeSequence$time_units`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$time_units()

## ------------------------------------------------
## Method `TreeSequence$min_time`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$min_time()

## ------------------------------------------------
## Method `TreeSequence$max_time`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$max_time()

## ------------------------------------------------
## Method `TreeSequence$metadata_length`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$metadata_length()
}
\seealso{
\code{\link{ts_load}}

\code{\link{ts_py_to_r}}, \code{\link{ts_load}}, and
  \code{\link[=TreeSequence]{TreeSequence$dump}}.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{pointer}}{external pointer to the tree sequence}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TreeSequence-new}{\code{TreeSequence$new()}}
\item \href{#method-TreeSequence-dump}{\code{TreeSequence$dump()}}
\item \href{#method-TreeSequence-write}{\code{TreeSequence$write()}}
\item \href{#method-TreeSequence-dump_tables}{\code{TreeSequence$dump_tables()}}
\item \href{#method-TreeSequence-print}{\code{TreeSequence$print()}}
\item \href{#method-TreeSequence-r_to_py}{\code{TreeSequence$r_to_py()}}
\item \href{#method-TreeSequence-num_provenances}{\code{TreeSequence$num_provenances()}}
\item \href{#method-TreeSequence-num_populations}{\code{TreeSequence$num_populations()}}
\item \href{#method-TreeSequence-num_migrations}{\code{TreeSequence$num_migrations()}}
\item \href{#method-TreeSequence-num_individuals}{\code{TreeSequence$num_individuals()}}
\item \href{#method-TreeSequence-num_samples}{\code{TreeSequence$num_samples()}}
\item \href{#method-TreeSequence-num_nodes}{\code{TreeSequence$num_nodes()}}
\item \href{#method-TreeSequence-num_edges}{\code{TreeSequence$num_edges()}}
\item \href{#method-TreeSequence-num_trees}{\code{TreeSequence$num_trees()}}
\item \href{#method-TreeSequence-num_sites}{\code{TreeSequence$num_sites()}}
\item \href{#method-TreeSequence-num_mutations}{\code{TreeSequence$num_mutations()}}
\item \href{#method-TreeSequence-sequence_length}{\code{TreeSequence$sequence_length()}}
\item \href{#method-TreeSequence-time_units}{\code{TreeSequence$time_units()}}
\item \href{#method-TreeSequence-min_time}{\code{TreeSequence$min_time()}}
\item \href{#method-TreeSequence-max_time}{\code{TreeSequence$max_time()}}
\item \href{#method-TreeSequence-metadata_length}{\code{TreeSequence$metadata_length()}}
\item \href{#method-TreeSequence-clone}{\code{TreeSequence$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-new"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{\link{TreeSequence}} from a file or a pointer.
  See \code{\link{ts_load}} for details and examples.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$new(
  file,
  skip_tables = FALSE,
  skip_reference_sequence = FALSE,
  pointer = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{a string specifying the full path of the tree sequence file.}

\item{\code{skip_tables}}{logical; if \code{TRUE}, load only non-table information.}

\item{\code{skip_reference_sequence}}{logical; if \code{TRUE}, skip loading
reference sequence information.}

\item{\code{pointer}}{an external pointer (\code{externalptr}) to a tree sequence.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the corresponding Python function at
  \url{https://tskit.dev/tskit/docs/latest/python-api.html#tskit.load}.
}

\subsection{Returns}{
A \code{\link{TreeSequence}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- TreeSequence$new(file = ts_file)
is(ts)
ts
ts$num_nodes()
# Also
ts <- ts_load(ts_file)
is(ts)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-dump"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-dump}{}}}
\subsection{Method \code{dump()}}{
Write a tree sequence to a file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$dump(file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{a string specifying the full path of the tree sequence file.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the corresponding Python function at
  \url{https://tskit.dev/tskit/docs/latest/python-api.html#tskit.TreeSequence.dump}.
}

\subsection{Returns}{
No return value; called for side effects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
dump_file <- tempfile()
ts$dump(dump_file)
ts$write(dump_file) # alias
\dontshow{file.remove(dump_file)}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-write"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-write}{}}}
\subsection{Method \code{write()}}{
Alias for \code{\link[=TreeSequence]{TreeSequence$dump}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$write(file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{see \code{\link[=TreeSequence]{TreeSequence$dump}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-dump_tables"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-dump_tables}{}}}
\subsection{Method \code{dump_tables()}}{
Copy the tables into a \code{\link{TableCollection}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$dump_tables()}\if{html}{\out{</div>}}
}

\subsection{Details}{
See the corresponding Python function at
  \url{https://tskit.dev/tskit/docs/latest/python-api.html#tskit.TreeSequence.dump_tables}.
}

\subsection{Returns}{
A \code{\link{TableCollection}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
tc <- ts$dump_tables()
is(tc)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-print"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-print}{}}}
\subsection{Method \code{print()}}{
Print a summary of a tree sequence and its contents.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with two data.frames; the first contains tree sequence
  properties and their values; the second contains the number of rows in
  each table and the length of their metadata.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$print()
ts
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-r_to_py"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-r_to_py}{}}}
\subsection{Method \code{r_to_py()}}{
This function saves a tree sequence from R to disk and
  loads it into reticulate Python for use with the \code{tskit} Python API.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$r_to_py(tskit_module = get_tskit_py(), cleanup = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tskit_module}}{reticulate Python module of \code{tskit}. By default,
it calls \code{\link{get_tskit_py}} to obtain the module.}

\item{\code{cleanup}}{logical; delete the temporary file at the end of the function?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Tree sequence in reticulate Python.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
  ts_file <- system.file("examples/test.trees", package = "RcppTskit")
  ts_r <- ts_load(ts_file)
  is(ts_r)
  ts_r$num_individuals() # 8

  # Transfer the tree sequence to reticulate Python and use tskit Python API
  tskit <- get_tskit_py()
  if (check_tskit_py(tskit)) {
    ts_py <- ts_r$r_to_py()
    is(ts_py)
    ts_py$num_individuals # 8
    ts2_py <- ts_py$simplify(samples = c(0L, 1L, 2L, 3L))
    ts_py$num_individuals # 8
    ts2_py$num_individuals # 2
    ts2_py$num_nodes # 8
    ts2_py$tables$nodes$time # 0.0 ... 5.0093910
  }
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-num_provenances"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-num_provenances}{}}}
\subsection{Method \code{num_provenances()}}{
Get the number of provenances in a tree sequence.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$num_provenances()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_provenances()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-num_populations"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-num_populations}{}}}
\subsection{Method \code{num_populations()}}{
Get the number of populations in a tree sequence.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$num_populations()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_populations()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-num_migrations"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-num_migrations}{}}}
\subsection{Method \code{num_migrations()}}{
Get the number of migrations in a tree sequence.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$num_migrations()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_migrations()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-num_individuals"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-num_individuals}{}}}
\subsection{Method \code{num_individuals()}}{
Get the number of individuals in a tree sequence.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$num_individuals()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_individuals()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-num_samples"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-num_samples}{}}}
\subsection{Method \code{num_samples()}}{
Get the number of samples (of nodes) in a tree sequence.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$num_samples()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_samples()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-num_nodes"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-num_nodes}{}}}
\subsection{Method \code{num_nodes()}}{
Get the number of nodes in a tree sequence.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$num_nodes()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_nodes()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-num_edges"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-num_edges}{}}}
\subsection{Method \code{num_edges()}}{
Get the number of edges in a tree sequence.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$num_edges()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_edges()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-num_trees"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-num_trees}{}}}
\subsection{Method \code{num_trees()}}{
Get the number of trees in a tree sequence.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$num_trees()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_trees()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-num_sites"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-num_sites}{}}}
\subsection{Method \code{num_sites()}}{
Get the number of sites in a tree sequence.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$num_sites()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_sites()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-num_mutations"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-num_mutations}{}}}
\subsection{Method \code{num_mutations()}}{
Get the number of mutations in a tree sequence.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$num_mutations()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$num_mutations()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-sequence_length"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-sequence_length}{}}}
\subsection{Method \code{sequence_length()}}{
Get the sequence length.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$sequence_length()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$sequence_length()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-time_units"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-time_units}{}}}
\subsection{Method \code{time_units()}}{
Get the time units string.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$time_units()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$time_units()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-min_time"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-min_time}{}}}
\subsection{Method \code{min_time()}}{
Get the min time in node table and mutation table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$min_time()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$min_time()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-max_time"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-max_time}{}}}
\subsection{Method \code{max_time()}}{
Get the max time in node table and mutation table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$max_time()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$max_time()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-metadata_length"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-metadata_length}{}}}
\subsection{Method \code{metadata_length()}}{
Get the length of metadata in a tree sequence and its tables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$metadata_length()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A named list with the length of metadata.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
ts$metadata_length()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TreeSequence-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TreeSequence-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeSequence$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
