% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{uuid_generate_name}
\alias{uuid_generate_name}
\title{Generate UUIDs Version 5}
\usage{
uuid_generate_name(x, ns = "x500dn")
}
\arguments{
\item{x}{Character vector.}

\item{ns}{Namespace string. Allowed values: dns, url, oid, x500dn.}
}
\value{
Character vector with UUIDs.
}
\description{
Function generates name-based uuid is derived from content in a namespace.
A uuid with identical content shall yield the same uuid.
Hashing algorithm is SHA1.
}
\note{
This function generates valid uuids for the \code{NA} and empty strings.
}
\examples{
# generate name UUIDs
uuid_generate_name(c("one", "two"))

}
\references{
\url{https://www.boost.org/doc/libs/1_72_0/libs/uuid/doc/uuid.html#Name\%20Generator}
}
