% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReSurvIndividualData.R
\name{ReSurv.default}
\alias{ReSurv.default}
\title{Fit \code{ReSurv} models on the individual data.}
\usage{
\method{ReSurv}{default}(
  IndividualDataPP,
  hazard_model = "COX",
  tie = "efron",
  baseline = "spline",
  continuous_features_scaling_method = "minmax",
  random_seed = 1,
  hparameters = list(),
  percentage_data_training = 0.8,
  grouping_method = "exposure",
  check_value = 1.85
)
}
\arguments{
\item{IndividualDataPP}{IndividualDataPP object to use for the \code{ReSurv} fit.}

\item{hazard_model}{\code{character}, hazard model supported from our package, must be provided as a string. The model can be chosen from:
\itemize{
\item{\code{"COX"}: Standard Cox model for the hazard.}
\item{\code{"NN"}: Deep Survival Neural Network.}
\item{\code{"XGB"}: eXtreme Gradient Boosting.}
}}

\item{tie}{ties handling, default is the Efron approach.}

\item{baseline}{handling the baseline hazard. Default is a spline.}

\item{continuous_features_scaling_method}{method to preprocess the features}

\item{random_seed}{\code{integer}, random seed set for reproducibility}

\item{hparameters}{\code{list}, hyperparameters for the machine learning models. It will be disregarded for the cox approach.}

\item{percentage_data_training}{\code{numeric}, percentage of data used for training on the upper triangle.}

\item{grouping_method}{\code{character}, use probability or exposure approach to group from input to output development factors. Choice between:
\itemize{
\item{\code{"exposure"}}
\item{\code{"probability"}}
}
Default is \code{"exposure"}.}

\item{check_value}{\code{numeric}, check hazard value on initial granularity, if above threshold we increase granularity to try and adjust the development factor.}
}
\value{
\code{ReSurv} fit. A list containing
\itemize{
\item{\code{model.out}: \code{list} containing the pre-processed covariates data for the fit (\code{data}) and the basic model output (\code{model.out};COX, XGB or NN).}
\item{\code{is_lkh}: \code{numeric} Training negative log likelihood.}
\item{\code{os_lkh}:  \code{numeric} Validation  negative log likelihood. Not available for COX.}
\item{\code{hazard_frame}: \code{data.frame} containing the fitted hazard model with the corresponding covariates. It contains:}
   \itemize{
   \item{\code{expg}: fitted risk score.}
   \item{\code{baseline}: fitted baseline.}
   \item{\code{hazard}: fitted hazard rate (\code{expg}*\code{baseline}).}
   \item{\code{f_i}: fitted development factors.}
   \item{\code{cum_f_i}: fitted cumulative development factors.}
   \item{\code{S_i}:fitted survival function.}
   \item{\code{S_i_lag}:fitted survival function (lag version, for further information see \code{?dplyr::lag}).}
   \item{\code{S_i_lead}:fitted survival function (lead version, for further information see \code{?dplyr::lead}).}
   }
\item{\code{hazard_model}: \code{string} chosen hazard model (COX, NN or XGB)}
\item{\code{IndividualDataPP}: starting \code{IndividualDataPP} object.}
}
}
\description{
This function fits and computes the reserves for the \code{ReSurv} models
}
\details{
The model fit uses the theoretical framework of Hiabu et al. (2023), that relies on the
correspondence between hazard models and development factors:

To be completed with final notation of the paper.

The \code{ReSurv} package assumes proportional hazard models.
Given an i.i.d. sample \eqn{\left\{y_i,x_i\right\}_{i=1, \ldots, n}} the individual hazard at time \eqn{t} is:

\eqn{\lambda_i(t)=\lambda_0(t)e^{y_i(x_i)}}

Composed of a baseline \eqn{\lambda_0(t)} and a proportional effect \eqn{e^{y_i(x_i)}}.

Currently, the implementation allows to optimize the partial likelihood (concerning the proportional effects) using one of the following statistical learning approaches:
\itemize{
\item{\href{https://github.com/therneau/survival}{COX}}
\item{\href{https://bmcmedresmethodol.biomedcentral.com/articles/10.1186/s12874-018-0482-1}{Neural Networks}}
\item{\href{https://xgboost.readthedocs.io/en/stable/}{eXtreme Gradient Boosting}}
}
}
\examples{

input_data_0 <- data_generator(
random_seed = 1964,
scenario = "alpha",
time_unit = 1,
years = 4,
period_exposure = 100)

individual_data <- IndividualDataPP(data = input_data_0,
categorical_features = "claim_type",
continuous_features = "AP",
accident_period = "AP",
calendar_period = "RP",
input_time_granularity = "years",
output_time_granularity = "years",
years=4)


resurv_fit_cox <- ReSurv(individual_data,
hazard_model = "COX")





}
\references{
Pittarello, G., Hiabu, M., & Villegas, A. M. (2023). Chain Ladder Plus: a versatile approach for claims reserving. arXiv preprint arXiv:2301.03858.

Therneau, T. M., & Lumley, T. (2015). Package ‘survival’. R Top Doc, 128(10), 28-33.

Katzman, J. L., Shaham, U., Cloninger, A., Bates, J., Jiang, T., & Kluger, Y. (2018). DeepSurv: personalized treatment recommender system using a Cox proportional hazards deep neural network. BMC medical research methodology, 18(1), 1-12.

Chen, T., He, T., Benesty, M., & Khotilovich, V. (2019). Package ‘xgboost’. R version, 90, 1-66.
}
