#Forked from RColorBrewer 1.1-2 on 13-Feb-2016

   divlist  <- c("dPBIYlBu","dPBIYlPu","dPBIPuGn","dPBIPuOr","dPBIRdBu","dPBIRdGy","dPBIRdGn")
   names(divlist) <- divlist
   quallist <- c("qMSOStd","qMSO12","qMSO15","qMSOBuWarm","qMSOBu","qMSOBu2","qMSOBuGn","qMSOGn",
                 "qMSOGnYl","qMSOYl","qMSOYlOr","qMSOOr","qMSOOrRd","qMSORdOr","qMSORd","qMSORdPu",
				 "qMSOPu", "qMSOPu2","qMSOMed","qMSOPap","qMSOMrq","qMSOSlp","qMSOAsp","qPBI")
   names(quallist) <- quallist
   seqlist  <- c("sPBIGn","sPBIGy1","sPBIRd","sPBIYl","sPBIGy2","sPBIBu","sPBIOr","sPBIPu",
   	             "sPBIYlGn","sPBIRdPu")
   names(seqlist) <- seqlist
   colorblindlist<-c("dPBIYlBu","dPBIYlPu","dPBIPuGn","dPBIPuOr","dPBIRdBu",
					 "qMSO12","qMSO15","qMSOBuGn", #TODO: Validate qualitative palettes for colorblind friendliness
					  seqlist)

   divnum <- rep(11, length(divlist))
   names(divnum)  <- divlist
   qualnum <- c(10, 8, 8, 8, 8, 8, 8, 8,
                 8, 8, 8, 8, 8, 8, 8, 8,
                 8, 8, 8, 8, 8, 8, 8, 8)
   names(qualnum) <- quallist
   seqnum <- rep(9, length(seqlist))
   names(seqnum) <- seqlist
   namelist<-c(divlist,quallist,seqlist)
   maxcolors <- c(divnum,qualnum,seqnum)
   catlist<-rep(c("div","qual","seq"),c(length(divlist),length(quallist),length(seqlist)))
   colorblind <- (namelist %in% colorblindlist)

   #' @export
   redmonder.pal.info<-data.frame(maxcolors=maxcolors,category=catlist,row.names=namelist,
								colorblind=colorblind)


#' @export
redmonder.pal<-function(n,name){
   if(!(name %in% namelist)){
   stop(paste(name,"is not a valid palette name for redmonder.pal\n"))
   }
   if(n<3){
   warning("minimal value for n is 3, returning requested palette with 3 different levels\n")
   return(redmonder.pal(3,name))
   }
   if(n>maxcolors[which(name==namelist)]){
   warning(paste("n too large, allowed maximum for palette",name,"is",maxcolors[which(name==namelist)]),
        "\nReturning the palette you asked for with that many colors\n")
   return(redmonder.pal(maxcolors[which(name==namelist)],name))
   }

   switch(name,
   # QUALITATIVE PALETTES
    qMSOStd = switch(n-2,
	    rgb(c(192,255,255),
            c(  0,  0,192),
            c(  0,  0,  0),maxColorValue=255),
        rgb(c(192,255,255,255),
            c(  0,  0,192,255),
            c(  0,  0,  0,  0),maxColorValue=255),
	    rgb(c(192,255,255,255,146),
            c(  0,  0,192,255,208),
            c(  0,  0,  0,  0, 80),maxColorValue=255),
	    rgb(c(192,255,255,255,146,  0),
            c(  0,  0,192,255,208,176),
            c(  0,  0,  0,  0, 80, 80),maxColorValue=255),
    	rgb(c(192,255,255,255,146,  0,  0),
            c(  0,  0,192,255,208,176,176),
            c(  0,  0,  0,  0, 80, 80,240),maxColorValue=255),
        rgb(c(192,255,255,255,146,  0,  0,  0),
            c(  0,  0,192,255,208,176,176,112),
            c(  0,  0,  0,  0, 80, 80,240,192),maxColorValue=255),
        rgb(c(192,255,255,255,146,  0,  0,  0,  0),
            c(  0,  0,192,255,208,176,176,112, 32),
            c(  0,  0,  0,  0, 80, 80,240,192, 96),maxColorValue=255),
        rgb(c(192,255,255,255,146,  0,  0,  0,  0,112),
            c(  0,  0,192,255,208,176,176,112, 32, 48),
            c(  0,  0,  0,  0, 80, 80,240,192, 96,160),maxColorValue=255)
        ),
    qMSO12 =  switch(n-2,
        rgb(c(238, 31, 79),
            c(236, 73,129),
            c(225,125,189),maxColorValue=255),
        rgb(c(238, 31, 79,192),
            c(236, 73,129, 80),
            c(225,125,189, 77),maxColorValue=255),
        rgb(c(238, 31, 79,192,155),
            c(236, 73,129, 80,187),
            c(225,125,189, 77, 89),maxColorValue=255),
        rgb(c(238, 31, 79,192,155,128),
            c(236, 73,129, 80,187,100),
            c(225,125,189, 77, 89,162),maxColorValue=255),
        rgb(c(238, 31, 79,192,155,128, 75),
            c(236, 73,129, 80,187,100,172),
            c(225,125,189, 77, 89,162,198),maxColorValue=255),
        rgb(c(238, 31, 79,192,155,128, 75,247),
            c(236, 73,129, 80,187,100,172,150),
            c(225,125,189, 77, 89,162,198, 70),maxColorValue=255)
        ),
    qMSO15 = switch(n-2,
        rgb(c(231, 68, 91),
            c(230, 84,155),
            c(230,106,213),maxColorValue=255),
		rgb(c(231, 68, 91,237),
            c(230, 84,155,125),
            c(230,106,213, 49),maxColorValue=255),
		rgb(c(231, 68, 91,237,165),
            c(230, 84,155,125,165),
            c(230,106,213, 49,165),maxColorValue=255),
		rgb(c(231, 68, 91,237,165,255),
            c(230, 84,155,125,165,192),
            c(230,106,213, 49,165,  0),maxColorValue=255),
		rgb(c(231, 68, 91,237,165,255, 68),
            c(230, 84,155,125,165,192,114),
            c(230,106,213, 49,165,  0,196),maxColorValue=255),
        rgb(c(231, 68, 91,237,165,255, 68,112),
            c(230, 84,155,125,165,192,114,173),
            c(230,106,213, 49,165,  0,196, 71),maxColorValue=255)
        ),
    qMSOBuWarm =   switch(n-2,
        rgb(c(172, 36, 74),
            c(203, 40,102),
            c(249, 82,172),maxColorValue=255),
		rgb(c(172, 36, 74, 98),
            c(203, 40,102,157),
            c(249, 82,172,209),maxColorValue=255),
		rgb(c(172, 36, 74, 98, 41),
            c(203, 40,102,157,127),
            c(249, 82,172,209,213),maxColorValue=255),
		rgb(c(172, 36, 74, 98, 41,127),
            c(203, 40,102,157,127,143),
            c(249, 82,172,209,213,169),maxColorValue=255),
		rgb(c(172, 36, 74, 98, 41,127, 90),
            c(203, 40,102,157,127,143,162),
            c(249, 82,172,209,213,169,174),maxColorValue=255),
	    rgb(c(172, 36, 74, 98, 41,127, 90,157),
            c(203, 40,102,157,127,143,162,144),
            c(249, 82,172,209,213,169,174,160),maxColorValue=255)
        ),
    qMSOBu = switch(n-2,
        rgb(c(219, 23, 15),
            c(239, 64,111),
            c(249,109,198),maxColorValue=255),
        rgb(c(219, 23, 15,  0),
            c(239, 64,111,157),
            c(249,109,198,217),maxColorValue=255),
        rgb(c(219, 23, 15,  0, 11),
            c(239, 64,111,157,208),
            c(249,109,198,217,217),maxColorValue=255),
        rgb(c(219, 23, 15,  0, 11, 16),
            c(239, 64,111,157,208,207),
            c(249,109,198,217,217,155),maxColorValue=255),
        rgb(c(219, 23, 15,  0, 11, 16,124),
            c(239, 64,111,157,208,207,202),
            c(249,109,198,217,217,155, 98),maxColorValue=255),
        rgb(c(219, 23, 15,  0, 11, 16,124,165),
            c(239, 64,111,157,208,207,202,194),
            c(249,109,198,217,217,155, 98, 73),maxColorValue=255)
        ),
    qMSOBu2 = switch(n-2,
        rgb(c(223, 51, 28),
            c(227, 91,173),
            c(229,116,228),maxColorValue=255),
        rgb(c(223, 51, 28, 38),
            c(227, 91,173,131),
            c(229,116,228,198),maxColorValue=255),
        rgb(c(223, 51, 28, 38, 39),
            c(227, 91,173,131,206),
            c(229,116,228,198,215),maxColorValue=255),
        rgb(c(223, 51, 28, 38, 39, 66),
            c(227, 91,173,131,206,186),
            c(229,116,228,198,215,151),maxColorValue=255),
        rgb(c(223, 51, 28, 38, 39, 66, 62),
            c(227, 91,173,131,206,186,136),
            c(229,116,228,198,215,151, 83),maxColorValue=255),
        rgb(c(223, 51, 28, 38, 39, 66, 62, 98),
            c(227, 91,173,131,206,186,136,163),
            c(229,116,228,198,215,151, 83,159),maxColorValue=255)
        ),
    qMSOBuGn = switch(n-2,
        rgb(c(206, 55, 52),
            c(219, 53,148),
            c(230, 69,186),maxColorValue=255),
        rgb(c(206, 55, 52, 88),
            c(219, 53,148,182),
            c(230, 69,186,192),maxColorValue=255),
        rgb(c(206, 55, 52, 88,117),
            c(219, 53,148,182,189),
            c(230, 69,186,192,167),maxColorValue=255),
        rgb(c(206, 55, 52, 88,117,122),
            c(219, 53,148,182,189,140),
            c(230, 69,186,192,167,142),maxColorValue=255),
        rgb(c(206, 55, 52, 88,117,122,132),
            c(219, 53,148,182,189,140,172),
            c(230, 69,186,192,167,142,182),maxColorValue=255),
        rgb(c(206, 55, 52, 88,117,122,132, 38),
            c(219, 53,148,182,189,140,172,131),
            c(230, 69,186,192,167,142,182,198),maxColorValue=255)
        ),
    qMSOGn =  switch(n-2,
        rgb(c(227, 69, 84),
            c(222, 95,158),
            c(209, 81, 57),maxColorValue=255),
        rgb(c(227, 69, 84,138),
            c(222, 95,158,184),
            c(209, 81, 57, 51),maxColorValue=255),
        rgb(c(227, 69, 84,138,192),
            c(222, 95,158,184,207),
            c(209, 81, 57, 51, 58),maxColorValue=255),
        rgb(c(227, 69, 84,138,192,  2),
            c(222, 95,158,184,207,150),
            c(209, 81, 57, 51, 58,118),maxColorValue=255),
        rgb(c(227, 69, 84,138,192,  2, 74),
            c(222, 95,158,184,207,150,181),
            c(209, 81, 57, 51, 58,118,196),maxColorValue=255),
	    rgb(c(227, 69, 84,138,192,  2, 74,  9),
            c(222, 95,158,184,207,150,181,137),
            c(209, 81, 57, 51, 58,118,196,117),maxColorValue=255)
        ),
    qMSOGnYl = switch(n-2,
	    rgb(c(226, 69,153),
            c(223, 95,203),
            c(204, 81, 56),maxColorValue=255),
	    rgb(c(226, 69,153, 99),
            c(223, 95,203,165),
            c(204, 81, 56, 55),maxColorValue=255),
	    rgb(c(226, 69,153, 99, 55),
            c(223, 95,203,165,167),
            c(204, 81, 56, 55,111),maxColorValue=255),
	    rgb(c(226, 69,153, 99, 55, 68),
            c(223, 95,203,165,167,193),
            c(204, 81, 56, 55,111,163),maxColorValue=255),
	    rgb(c(226, 69,153, 99, 55, 68, 78),
            c(223, 95,203,165,167,193,179),
            c(204, 81, 56, 55,111,163,207),maxColorValue=255),
	    rgb(c(226, 69,153, 99, 55, 68, 78, 81),
            c(223, 95,203,165,167,193,179,195),
            c(204, 81, 56, 55,111,163,207,249),maxColorValue=255)
        ),
    qMSOYl = switch(n-2,
	    rgb(c(229, 57,225),
            c(222, 48,202),
            c(219, 42,  8),maxColorValue=255),
	    rgb(c(229, 57,225,248),
            c(222, 48,202,147),
            c(219, 42,  8, 29),maxColorValue=255),
	    rgb(c(229, 57,225,248,206),
            c(222, 48,202,147,141),
            c(219, 42,  8, 29, 62),maxColorValue=255),
	    rgb(c(229, 57,225,248,206,236),
            c(222, 48,202,147,141,112),
            c(219, 42,  8, 29, 62, 22),maxColorValue=255),
	    rgb(c(229, 57,225,248,206,236,230),
            c(222, 48,202,147,141,112, 72),
            c(219, 42,  8, 29, 62, 22, 35),maxColorValue=255),
	    rgb(c(229, 57,225,248,206,236,230,156),
            c(222, 48,202,147,141,112, 72,106),
            c(219, 42,  8, 29, 62, 22, 35,106),maxColorValue=255)
        ),
    qMSOYlOr = switch(n-2,
	    rgb(c(251, 78,240),
            c(238, 59,162),
            c(201, 48, 46),maxColorValue=255),
	    rgb(c(251, 78,240,165),
            c(238, 59,162,100),
            c(201, 48, 46, 78),maxColorValue=255),
	    rgb(c(251, 78,240,165,181),
            c(238, 59,162,100,139),
            c(201, 48, 46, 78,128),maxColorValue=255),
	    rgb(c(251, 78,240,165,181,195),
            c(238, 59,162,100,139,152),
            c(201, 48, 46, 78,128,109),maxColorValue=255),
	    rgb(c(251, 78,240,165,181,195,161),
            c(238, 59,162,100,139,152,149),
            c(201, 48, 46, 78,128,109,116),maxColorValue=255),
	    rgb(c(251, 78,240,165,181,195,161,193),
            c(238, 59,162,100,139,152,149,117),
            c(201, 48, 46, 78,128,109,116, 41),maxColorValue=255)
        ),
    qMSOOr = switch(n-2,
	    rgb(c(204, 99,228),
            c(221,112,131),
            c(234, 82, 18),maxColorValue=255),
	    rgb(c(204, 99,228,189),
            c(221,112,131, 88),
            c(234, 82, 18, 44),maxColorValue=255),
	    rgb(c(204, 99,228,189,134),
            c(221,112,131, 88, 86),
            c(234, 82, 18, 44, 64),maxColorValue=255),
	    rgb(c(204, 99,228,189,134,155),
            c(221,112,131, 88, 86,131),
            c(234, 82, 18, 44, 64, 87),maxColorValue=255),
	    rgb(c(204, 99,228,189,134,155,194),
            c(221,112,131, 88, 86,131,188),
            c(234, 82, 18, 44, 64, 87,128),maxColorValue=255),
	    rgb(c(204, 99,228,189,134,155,194,148),
            c(221,112,131, 88, 86,131,188,160),
            c(234, 82, 18, 44, 64, 87,128,136),maxColorValue=255)
        ),
    qMSOOrRd = switch(n-2,
	    rgb(c(233,105,211),
            c(229,100, 73),
            c(220,100, 23),maxColorValue=255),
	    rgb(c(233,105,211,155),
            c(229,100, 73, 45),
            c(220,100, 23, 31),maxColorValue=255),
	    rgb(c(233,105,211,155,162),
            c(229,100, 73, 45,142),
            c(220,100, 23, 31,106),maxColorValue=255),
	    rgb(c(233,105,211,155,162,149),
            c(229,100, 73, 45,142, 98),
            c(220,100, 23, 31,106, 81),maxColorValue=255),
	    rgb(c(233,105,211,155,162,149,145),
            c(229,100, 73, 45,142, 98,132),
            c(220,100, 23, 31,106, 81,133),maxColorValue=255),
	    rgb(c(233,105,211,155,162,149,145,133),
            c(229,100, 73, 45,142, 98,132, 93),
            c(220,100, 23, 31,106, 81,133, 93),maxColorValue=255)
        ),
    qMSORdOr = switch(n-2,
	    rgb(c(238, 80,232),
            c(236, 80, 76),
            c(225, 70, 34),maxColorValue=255),
	    rgb(c(238, 80,232,225),
            c(236, 80, 76,189),
            c(225, 70, 34, 71),maxColorValue=255),
	    rgb(c(238, 80,232,225,182),
            c(236, 80, 76,189, 73),
            c(225, 70, 34, 71, 38),maxColorValue=255),
	    rgb(c(238, 80,232,225,182,255),
            c(236, 80, 76,189, 73,132),
            c(225, 70, 34, 71, 38, 39),maxColorValue=255),
	    rgb(c(238, 80,232,225,182,255,204),
            c(236, 80, 76,189, 73,132,153),
            c(225, 70, 34, 71, 38, 39,  0),maxColorValue=255),
	    rgb(c(238, 80,232,225,182,255,204,178),
            c(236, 80, 76,189, 73,132,153, 38),
            c(225, 70, 34, 71, 38, 39,  0,  0),maxColorValue=255)
        ),
    qMSORd = switch(n-2,
	    rgb(c(229, 50,165),
            c(194, 50, 48),
            c( 67, 50, 15),maxColorValue=255),
	    rgb(c(229, 50,165,213),
            c(194, 50, 48, 88),
            c( 67, 50, 15, 22),maxColorValue=255),
	    rgb(c(229, 50,165,213,225),
            c(194, 50, 48, 88,152),
            c( 67, 50, 15, 22, 37),maxColorValue=255),
	    rgb(c(229, 50,165,213,225,177),
            c(194, 50, 48, 88,152,156),
            c( 67, 50, 15, 22, 37,125),maxColorValue=255),
	    rgb(c(229, 50,165,213,225,177,127),
            c(194, 50, 48, 88,152,156, 95),
            c( 67, 50, 15, 22, 37,125, 82),maxColorValue=255),
	    rgb(c(229, 50,165,213,225,177,127,178),
            c(194, 50, 48, 88,152,156, 95,125),
            c( 67, 50, 15, 22, 37,125, 82, 73),maxColorValue=255)
        ),
    qMSORdPu = switch(n-2,
	    rgb(c(216, 69,227),
            c(217, 69, 45),
            c(220, 81,145),maxColorValue=255),
	    rgb(c(216, 69,227,200),
            c(217, 69, 45, 48),
            c(220, 81,145,204),maxColorValue=255),
	    rgb(c(216, 69,227,200, 78),
            c(217, 69, 45, 48,166),
            c(220, 81,145,204,220),maxColorValue=255),
	    rgb(c(216, 69,227,200, 78, 71),
            c(217, 69, 45, 48,166,117),
            c(220, 81,145,204,220,231),maxColorValue=255),
	    rgb(c(216, 69,227,200, 78, 71,137),
            c(217, 69, 45, 48,166,117,113),
            c(220, 81,145,204,220,231,225),maxColorValue=255),
	    rgb(c(216, 69,227,200, 78, 71,137,213),
            c(217, 69, 45, 48,166,117,113, 71),
            c(220, 81,145,204,220,231,225,115),maxColorValue=255)
        ),
    qMSOPu = switch(n-2,
	    rgb(c(220, 55,173),
            c(216, 53,132),
            c(220, 69,198),maxColorValue=255),
	    rgb(c(220, 55,173,135),
            c(216, 53,132,132),
            c(220, 69,198,199),maxColorValue=255),
	    rgb(c(220, 55,173,135, 93),
            c(216, 53,132,132,115),
            c(220, 69,198,199,154),maxColorValue=255),
	    rgb(c(220, 55,173,135, 93,105),
            c(216, 53,132,132,115,151),
            c(220, 69,198,199,154,175),maxColorValue=255),
	    rgb(c(220, 55,173,135, 93,105,132),
            c(216, 53,132,132,115,151,172),
            c(220, 69,198,199,154,175,182),maxColorValue=255),
	    rgb(c(220, 55,173,135, 93,105,132,111),
            c(216, 53,132,132,115,151,172,129),
            c(220, 69,198,199,154,175,182,131),maxColorValue=255)
        ),
	qMSOPu2 = switch(n-2,
	    rgb(c(234, 99,146),
            c(229, 46, 39),
            c(235, 98,143),maxColorValue=255),
	    rgb(c(234, 99,146,155),
            c(229, 46, 39, 87),
            c(235, 98,143,211),maxColorValue=255),
	    rgb(c(234, 99,146,155,117),
            c(229, 46, 39, 87, 93),
            c(235, 98,143,211,217),maxColorValue=255),
	    rgb(c(234, 99,146,155,117,102),
            c(229, 46, 39, 87, 93, 94),
            c(235, 98,143,211,217,184),maxColorValue=255),
	    rgb(c(234, 99,146,155,117,102, 69),
            c(229, 46, 39, 87, 93, 94,165),
            c(235, 98,143,211,217,184,237),maxColorValue=255),
	    rgb(c(234, 99,146,155,117,102, 69, 89),
            c(229, 46, 39, 87, 93, 94,165,130),
            c(235, 98,143,211,217,184,237,219),maxColorValue=255)
        ),
	qMSOMed = switch(n-2,
	    rgb(c(235,119,148),
            c(221, 95,182),
            c(195, 85,210),maxColorValue=255),
	    rgb(c(235,119,148,221),
            c(221, 95,182,128),
            c(195, 85,210, 71),maxColorValue=255),
	    rgb(c(235,119,148,221,165),
            c(221, 95,182,128,171),
            c(195, 85,210, 71,129),maxColorValue=255),
	    rgb(c(235,119,148,221,165,216),
            c(221, 95,182,128,171,178),
            c(195, 85,210, 71,129, 92),maxColorValue=255),
	    rgb(c(235,119,148,221,165,216,123),
            c(221, 95,182,128,171,178,167),
            c(195, 85,210, 71,129, 92,157),maxColorValue=255),
	    rgb(c(235,119,148,221,165,216,123,150),
            c(221, 95,182,128,171,178,167,140),
            c(195, 85,210, 71,129, 92,157,140),maxColorValue=255)
        ),
	qMSOPap = switch(n-2,
	    rgb(c(254, 68,165),
            c(250, 77,181),
            c(201, 38,146),maxColorValue=255),
	    rgb(c(254, 68,165,243),
            c(250, 77,181,164),
            c(201, 38,146, 71),maxColorValue=255),
	    rgb(c(254, 68,165,243,231),
            c(250, 77,181,164,188),
            c(201, 38,146, 71, 41),maxColorValue=255),
	    rgb(c(254, 68,165,243,231,208),
            c(250, 77,181,164,188,146),
            c(201, 38,146, 71, 41,167),maxColorValue=255),
	    rgb(c(254, 68,165,243,231,208,156),
            c(250, 77,181,164,188,146,133),
            c(201, 38,146, 71, 41,167,192),maxColorValue=255),
	    rgb(c(254, 68,165,243,231,208,156,128),
            c(250, 77,181,164,188,146,133,158),
            c(201, 38,146, 71, 41,167,192,194),maxColorValue=255)
        ),
	qMSOMrq = switch(n-2,
	    rgb(c(221, 94, 65),
            c(221, 94,138),
            c(221, 94,179),maxColorValue=255),
	    rgb(c(221, 94, 65,166),
            c(221, 94,138,183),
            c(221, 94,179, 39),maxColorValue=255),
	    rgb(c(221, 94, 65,166,246),
            c(221, 94,138,183,146),
            c(221, 94,179, 39,  0),maxColorValue=255),
		rgb(c(221, 94, 65,166,246,131),
            c(221, 94,138,183,146,131),
            c(221, 94,179, 39,  0,131),maxColorValue=255),
		rgb(c(221, 94, 65,166,246,131,254),
            c(221, 94,138,183,146,131,195),
            c(221, 94,179, 39,  0,131,  6),maxColorValue=255),
	    rgb(c(221, 94, 65,166,246,131,254,223),
            c(221, 94,138,183,146,131,195, 83),
            c(221, 94,179, 39,  0,131,  6, 39),maxColorValue=255)
        ),
	qMSOSlp = switch(n-2,
	    rgb(c(180, 33, 78),
            c(220, 39,103),
            c(250, 69,200),maxColorValue=255),
	    rgb(c(180, 33, 78, 94),
            c(220, 39,103,204),
            c(250, 69,200,243),maxColorValue=255),
	    rgb(c(180, 33, 78, 94,167),
            c(220, 39,103,204,234),
            c(250, 69,200,243, 82),maxColorValue=255),
	    rgb(c(180, 33, 78, 94,167, 93),
            c(220, 39,103,204,234,206),
            c(250, 69,200,243, 82,175),maxColorValue=255),
	    rgb(c(180, 33, 78, 94,167, 93,255),
            c(220, 39,103,204,234,206,128),
            c(250, 69,200,243, 82,175, 33),maxColorValue=255),
	    rgb(c(180, 33, 78, 94,167, 93,255,241),
            c(220, 39,103,204,234,206,128, 65),
            c(250, 69,200,243, 82,175, 33, 36),maxColorValue=255)
        ),
	qMSOAsp = switch(n-2,
		rgb(c(227, 50,240),
            c(222, 50,127),
            c(209, 50,  9),maxColorValue=255),
		rgb(c(227, 50,240,159),
            c(222, 50,127, 41),
            c(209, 50,  9, 54),maxColorValue=255),
	    rgb(c(227, 50,240,159, 27),
            c(222, 50,127, 41, 88),
            c(209, 50,  9, 54,124),maxColorValue=255),
	    rgb(c(227, 50,240,159, 27, 78),
            c(222, 50,127, 41, 88,133),
            c(209, 50,  9, 54,124, 66),maxColorValue=255),
	    rgb(c(227, 50,240,159, 27, 78, 96),
            c(222, 50,127, 41, 88,133, 72),
            c(209, 50,  9, 54,124, 66,120),maxColorValue=255),
	    rgb(c(227, 50,240,159, 27, 78, 96,193),
            c(222, 50,127, 41, 88,133, 72,152),
            c(209, 50,  9, 54,124, 66,120, 89),maxColorValue=255)
        ),
	qPBI =  switch(n-2,
        rgb(c(  0,55,253),
            c(184,70, 98),
            c(170,73, 94),maxColorValue=255),
        rgb(c(  0,55,253,242),
            c(184,70, 98,200),
            c(170,73, 94, 17),maxColorValue=255),
        rgb(c(  0,55,253,242, 95),
            c(184,70, 98,200,107),
            c(170,73, 94, 17,109),maxColorValue=255),
        rgb(c(  0,55,253,242, 95,138),
            c(184,70, 98,200,107,212),
            c(170,73, 94, 17,109,235),maxColorValue=255),
		rgb(c(  0,55,253,242, 95,138,254),
            c(184,70, 98,200,107,212,150),
            c(170,73, 94, 17,109,235,102),maxColorValue=255),
        rgb(c(  0,55,253,242, 95,138,254,166),
            c(184,70, 98,200,107,212,150,105),
            c(170,73, 94, 17,109,235,102,153),maxColorValue=255)
        ),
   # DIVERGENT PALETTES
    dPBIYlBu = switch(n-2,
        rgb(c(121,182,245),
            c(100,150,211),
            c(  9, 13, 65),maxColorValue=255),
        rgb(c(121,182,245,247),
            c(100,150,211,222),
            c(  9, 13, 65,112),maxColorValue=255),
        rgb(c(121,182,245,247,250),
            c(100,150,211,222,233),
            c(  9, 13, 65,112,160),maxColorValue=255),
        rgb(c(121,182,245,247,250,245),
            c(100,150,211,222,233,245),
            c(  9, 13, 65,112,160,245),maxColorValue=255),
        rgb(c(121,182,245,247,250,245,208),
            c(100,150,211,222,233,245,238),
            c(  9, 13, 65,112,160,245,247),maxColorValue=255),
        rgb(c(121,182,245,247,250,245,208,185),
            c(100,150,211,222,233,245,238,229),
            c(  9, 13, 65,112,160,245,247,243),maxColorValue=255),
        rgb(c(121,182,245,247,250,245,208,185,161),
            c(100,150,211,222,233,245,238,229,221),
            c(  9, 13, 65,112,160,245,247,243,239),maxColorValue=255),
        rgb(c(121,182,245,247,250,245,208,185,161,104),
            c(100,150,211,222,233,245,238,229,221,159),
            c(  9, 13, 65,112,160,245,247,243,239,176),maxColorValue=255),
        rgb(c(121,182,245,247,250,245,208,185,161,104, 69),
            c(100,150,211,222,233,245,238,229,221,159,106),
            c(  9, 13, 65,112,160,245,247,243,239,176,118),maxColorValue=255)
        ),
    dPBIYlPu =  switch(n-2,
        rgb(c(121,182,245),
            c(100,150,211),
            c(  9, 13, 65),maxColorValue=255),
        rgb(c(121,182,245,247),
            c(100,150,211,222),
            c(  9, 13, 65,112),maxColorValue=255),
        rgb(c(121,182,245,247,250),
            c(100,150,211,222,233),
            c(  9, 13, 65,112,160),maxColorValue=255),
        rgb(c(121,182,245,247,250,245),
            c(100,150,211,222,233,245),
            c(  9, 13, 65,112,160,245),maxColorValue=255),
        rgb(c(121,182,245,247,250,245,219),
            c(100,150,211,222,233,245,195),
            c(  9, 13, 65,112,160,245,214),maxColorValue=255),
        rgb(c(121,182,245,247,250,245,219,202),
            c(100,150,211,222,233,245,195,165),
            c(  9, 13, 65,112,160,245,214,194),maxColorValue=255),
        rgb(c(121,182,245,247,250,245,219,202,184),
            c(100,150,211,222,233,245,195,165,135),
            c(  9, 13, 65,112,160,245,214,194,173),maxColorValue=255),
        rgb(c(121,182,245,247,250,245,219,202,184,125),
            c(100,150,211,222,233,245,195,165,135, 79),
            c(  9, 13, 65,112,160,245,214,194,173,115),maxColorValue=255),
        rgb(c(121,182,245,247,250,245,219,202,184,125, 83),
            c(100,150,211,222,233,245,195,165,135, 79, 53),
            c(  9, 13, 65,112,160,245,214,194,173,115, 77),maxColorValue=255)
        ),
    dPBIPuGn =  switch(n-2,
        rgb(c( 83,125,184),
            c( 53, 79,135),
            c( 77,115,173),maxColorValue=255),
        rgb(c( 83,125,184,202),
            c( 53, 79,135,165),
            c( 77,115,173,194),maxColorValue=255),
        rgb(c( 83,125,184,202,219),
            c( 53, 79,135,165,195),
            c( 77,115,173,194,214),maxColorValue=255),
        rgb(c( 83,125,184,202,219,245),
            c( 53, 79,135,165,195,245),
            c( 77,115,173,194,214,245),maxColorValue=255),
        rgb(c( 83,125,184,202,219,245,153),
            c( 53, 79,135,165,195,245,227),
            c( 77,115,173,194,214,245,221),maxColorValue=255),
        rgb(c( 83,125,184,202,219,245,153,102),
            c( 53, 79,135,165,195,245,227,212),
            c( 77,115,173,194,214,245,221,204),maxColorValue=255),
        rgb(c( 83,125,184,202,219,245,153,102, 51),
            c( 53, 79,135,165,195,245,227,212,198),
            c( 77,115,173,194,214,245,221,204,187),maxColorValue=255),
        rgb(c( 83,125,184,202,219,245,153,102, 51,  0),
            c( 53, 79,135,165,195,245,227,212,198,138),
            c( 77,115,173,194,214,245,221,204,187,128),maxColorValue=255),
	    rgb(c( 83,125,184,202,219,245,153,102, 51,  0,  0),
            c( 53, 79,135,165,195,245,227,212,198,138, 92),
            c( 77,115,173,194,214,245,221,204,187,128, 85),maxColorValue=255)
        ),
    dPBIPuOr =  switch(n-2,
	    rgb(c( 83,125,184),
            c( 53, 79,135),
            c( 77,115,173),maxColorValue=255),
	    rgb(c( 83,125,184,202),
            c( 53, 79,135,165),
            c( 77,115,173,194),maxColorValue=255),
	    rgb(c( 83,125,184,202,219),
            c( 53, 79,135,165,195),
            c( 77,115,173,194,214),maxColorValue=255),
	    rgb(c( 83,125,184,202,219,245),
            c( 53, 79,135,165,195,245),
            c( 77,115,173,194,214,245),maxColorValue=255),
	    rgb(c( 83,125,184,202,219,245,255),
            c( 53, 79,135,165,195,245,213),
            c( 77,115,173,194,214,245,194),maxColorValue=255),
	    rgb(c( 83,125,184,202,219,245,255,254),
            c( 53, 79,135,165,195,245,213,192),
            c( 77,115,173,194,214,245,194,163),maxColorValue=255),
	    rgb(c( 83,125,184,202,219,245,255,254,254),
            c( 53, 79,135,165,195,245,213,192,171),
            c( 77,115,173,194,214,245,194,163,133),maxColorValue=255),
	    rgb(c( 83,125,184,202,219,245,255,254,254,191),
            c( 53, 79,135,165,195,245,213,192,171,113),
            c( 77,115,173,194,214,245,194,163,133, 77),maxColorValue=255),
	    rgb(c( 83,125,184,202,219,245,255,254,254,191,127),
            c( 53, 79,135,165,195,245,213,192,171,113, 75),
            c( 77,115,173,194,214,245,194,163,133, 77, 51),maxColorValue=255)
        ),
    dPBIRdBu =  switch(n-2,
	    rgb(c(127,190,253),
            c( 49, 74,129),
            c( 47, 71,126),maxColorValue=255),
	    rgb(c(127,190,253,254),
            c( 49, 74,129,161),
            c( 47, 71,126,158),maxColorValue=255),
        rgb(c(127,190,253,254,254),
            c( 49, 74,129,161,192),
            c( 47, 71,126,158,191),maxColorValue=255),
        rgb(c(127,190,253,254,254,245),
            c( 49, 74,129,161,192,245),
            c( 47, 71,126,158,191,245),maxColorValue=255),
        rgb(c(127,190,253,254,254,245,208),
            c( 49, 74,129,161,192,245,238),
            c( 47, 71,126,158,191,245,247),maxColorValue=255),
        rgb(c(127,190,253,254,254,245,208,185),
            c( 49, 74,129,161,192,245,238,229),
            c( 47, 71,126,158,191,245,247,243),maxColorValue=255),
        rgb(c(127,190,253,254,254,245,208,185,161),
            c( 49, 74,129,161,192,245,238,229,221),
            c( 47, 71,126,158,191,245,247,243,239),maxColorValue=255),
        rgb(c(127,190,253,254,254,245,208,185,161,104),
            c( 49, 74,129,161,192,245,238,229,221,159),
            c( 47, 71,126,158,191,245,247,243,239,176),maxColorValue=255),
        rgb(c(127,190,253,254,254,245,208,185,161,104, 69),
            c( 49, 74,129,161,192,245,238,229,221,159,106),
            c( 47, 71,126,158,191,245,247,243,239,176,118),maxColorValue=255)
        ),
    dPBIRdGy = switch(n-2,
        rgb(c(127,190,253),
            c( 49, 74,129),
            c( 47, 71,126),maxColorValue=255),
        rgb(c(127,190,253,254),
            c( 49, 74,129,161),
            c( 47, 71,126,158),maxColorValue=255),
        rgb(c(127,190,253,254,254),
            c( 49, 74,129,161,192),
            c( 47, 71,126,158,191),maxColorValue=255),
        rgb(c(127,190,253,254,254,245),
            c( 49, 74,129,161,192,245),
            c( 47, 71,126,158,191,245),maxColorValue=255),
        rgb(c(127,190,253,254,254,245,175),
            c( 49, 74,129,161,192,245,181),
            c( 47, 71,126,158,191,245,182),maxColorValue=255),
        rgb(c(127,190,253,254,254,245,175,135),
            c( 49, 74,129,161,192,245,181,144),
            c( 47, 71,126,158,191,245,182,146),maxColorValue=255),
        rgb(c(127,190,253,254,254,245,175,135, 95),
            c( 49, 74,129,161,192,245,181,144,107),
            c( 47, 71,126,158,191,245,182,146,109),maxColorValue=255),
        rgb(c(127,190,253,254,254,245,175,135, 95, 41),
            c( 49, 74,129,161,192,245,181,144,107, 53),
            c( 47, 71,126,158,191,245,182,146,109, 55),maxColorValue=255),
        rgb(c(127,190,253,254,254,245,175,135, 95, 41, 28),
            c( 49, 74,129,161,192,245,181,144,107, 53, 35),
            c( 47, 71,126,158,191,245,182,146,109, 55, 37),maxColorValue=255)
        ),
   # SEQUENTIAL PALETTES
    dPBIRdGn = switch(n-2,
        rgb(c(127,190,253),
            c( 49, 74,129),
            c( 47, 71,126),maxColorValue=255),
        rgb(c(127,190,253,254),
            c( 49, 74,129,161),
            c( 47, 71,126,158),maxColorValue=255),
        rgb(c(127,190,253,254,254),
            c( 49, 74,129,161,192),
            c( 47, 71,126,158,191),maxColorValue=255),
        rgb(c(127,190,253,254,254,245),
            c( 49, 74,129,161,192,245),
            c( 47, 71,126,158,191,245),maxColorValue=255),
        rgb(c(127,190,253,254,254,245,153),
            c( 49, 74,129,161,192,245,227),
            c( 47, 71,126,158,191,245,221),maxColorValue=255),
        rgb(c(127,190,253,254,254,245,153,102),
            c( 49, 74,129,161,192,245,227,212),
            c( 47, 71,126,158,191,245,221,204),maxColorValue=255),
        rgb(c(127,190,253,254,254,245,153,102, 51),
            c( 49, 74,129,161,192,245,227,212,198),
            c( 47, 71,126,158,191,245,221,204,187),maxColorValue=255),
        rgb(c(127,190,253,254,254,245,153,102, 51,  0),
            c( 49, 74,129,161,192,245,227,212,198,138),
            c( 47, 71,126,158,191,245,221,204,187,128),maxColorValue=255),
        rgb(c(127,190,253,254,254,245,153,102, 51,  0,  0),
            c( 49, 74,129,161,192,245,227,212,198,138, 92),
            c( 47, 71,126,158,191,245,221,204,187,128, 85),maxColorValue=255)
        ),
	sPBIGn = switch(n-2,
	    rgb(c(233,204,175),
            c(248,229,209),
            c(246,226,206),maxColorValue=255),
	    rgb(c(233,204,175,146),
            c(248,229,209,190),
            c(246,226,206,186),maxColorValue=255),
	    rgb(c(233,204,175,146,117),
            c(248,229,209,190,170),
            c(246,226,206,186,166),maxColorValue=255),
	    rgb(c(233,204,175,146,117, 87),
            c(248,229,209,190,170,151),
            c(246,226,206,186,166,145),maxColorValue=255),
	    rgb(c(233,204,175,146,117, 87, 58),
            c(248,229,209,190,170,151,131),
            c(246,226,206,186,166,145,125),maxColorValue=255),
	    rgb(c(233,204,175,146,117, 87, 58, 29),
            c(248,229,209,190,170,151,131,112),
            c(246,226,206,186,166,145,125,105),maxColorValue=255),
	    rgb(c(233,204,175,146,117, 87, 58, 29,  0),
            c(248,229,209,190,170,151,131,112, 92),
            c(246,226,206,186,166,145,125,105, 85),maxColorValue=255)
        ),
	sPBIGy1 = switch(n-2,
        rgb(c(237,211,185),
            c(238,213,187),
            c(238,213,188),maxColorValue=255),
        rgb(c(237,211,185,159),
            c(238,213,187,162),
            c(238,213,188,163),maxColorValue=255),
        rgb(c(237,211,185,159,133),
            c(238,213,187,162,137),
            c(238,213,188,163,138),maxColorValue=255),
        rgb(c(237,211,185,159,133,106),
            c(238,213,187,162,137,111),
            c(238,213,188,163,138,112),maxColorValue=255),
        rgb(c(237,211,185,159,133,106, 80),
            c(238,213,187,162,137,111, 86),
            c(238,213,188,163,138,112, 87),maxColorValue=255),
        rgb(c(237,211,185,159,133,106, 80, 54),
            c(238,213,187,162,137,111, 86, 60),
            c(238,213,188,163,138,112, 87, 62),maxColorValue=255),
        rgb(c(237,211,185,159,133,106, 80, 54, 28),
            c(238,213,187,162,137,111, 86, 60, 35),
            c(238,213,188,163,138,112, 87, 62, 37),maxColorValue=255)
        ),
    sPBIRd = switch(n-2,
        rgb(c(254,238,222),
            c(242,218,194),
            c(241,217,193),maxColorValue=255),
        rgb(c(254,238,222,206),
            c(242,218,194,170),
            c(241,217,193,168),maxColorValue=255),
        rgb(c(254,238,222,206,191),
            c(242,218,194,170,146),
            c(241,217,193,168,144),maxColorValue=255),
        rgb(c(254,238,222,206,191,175),
            c(242,218,194,170,146,121),
            c(241,217,193,168,144,120),maxColorValue=255),
        rgb(c(254,238,222,206,191,175,159),
            c(242,218,194,170,146,121, 97),
            c(241,217,193,168,144,120, 96),maxColorValue=255),
        rgb(c(254,238,222,206,191,175,159,143),
            c(242,218,194,170,146,121, 97, 73),
            c(241,217,193,168,144,120, 96, 71),maxColorValue=255),
        rgb(c(254,238,222,206,191,175,159,143,127),
            c(242,218,194,170,146,121, 97, 73, 49),
            c(241,217,193,168,144,120, 96, 71, 47),maxColorValue=255)
        ),
    sPBIYl =  switch(n-2,
        rgb(c(252,236,219),
            c(249,230,212),
            c(234,206,178),maxColorValue=255),
        rgb(c(252,236,219,203),
            c(249,230,212,193),
            c(234,206,178,150),maxColorValue=255),
        rgb(c(252,236,219,203,187),
            c(249,230,212,193,175),
            c(234,206,178,150,122),maxColorValue=255),
        rgb(c(252,236,219,203,187,170),
            c(249,230,212,193,175,156),
            c(234,206,178,150,122, 93),maxColorValue=255),
        rgb(c(252,236,219,203,187,170,154),
            c(249,230,212,193,175,156,137),
            c(234,206,178,150,122, 93, 65),maxColorValue=255),
        rgb(c(252,236,219,203,187,170,154,137),
            c(249,230,212,193,175,156,137,119),
            c(234,206,178,150,122, 93, 65, 37),maxColorValue=255),
        rgb(c(252,236,219,203,187,170,154,137,121),
            c(249,230,212,193,175,156,137,119,100),
            c(234,206,178,150,122, 93, 65, 37,  9),maxColorValue=255)
        ),
    sPBIGy2 = switch(n-2,
        rgb(c(240,216,192),
            c(241,218,194),
            c(242,219,195),maxColorValue=255),
        rgb(c(240,216,192,168),
            c(241,218,194,171),
            c(242,219,195,172),maxColorValue=255),
        rgb(c(240,216,192,168,144),
            c(241,218,194,171,148),
            c(242,219,195,172,149),maxColorValue=255),
        rgb(c(240,216,192,168,144,120),
            c(241,218,194,171,148,124),
            c(242,219,195,172,149,125),maxColorValue=255),
        rgb(c(240,216,192,168,144,120, 96),
            c(241,218,194,171,148,124,101),
            c(242,219,195,172,149,125,102),maxColorValue=255),
        rgb(c(240,216,192,168,144,120, 96, 72),
            c(241,218,194,171,148,124,101, 77),
            c(242,219,195,172,149,125,102, 78),maxColorValue=255),
        rgb(c(240,216,192,168,144,120, 96, 72, 48),
            c(241,218,194,171,148,124,101, 77, 54),
            c(242,219,195,172,149,125,102, 78, 55),maxColorValue=255)
        ),
    sPBIBu =  switch(n-2,
		rgb(c(244,222,200),
            c(250,232,214),
            c(252,235,219),maxColorValue=255),
	     rgb(c(244,222,200,178),
            c(250,232,214,196),
            c(252,235,219,202),maxColorValue=255),
		rgb(c(244,222,200,178,157),
            c(250,232,214,196,178),
            c(252,235,219,202,185),maxColorValue=255),
		rgb(c(244,222,200,178,157,135),
            c(250,232,214,196,178,160),
            c(252,235,219,202,185,168),maxColorValue=255),
		rgb(c(244,222,200,178,157,135,113),
            c(250,232,214,196,178,160,142),
            c(252,235,219,202,185,168,152),maxColorValue=255),
		rgb(c(244,222,200,178,157,135,113, 91),
            c(250,232,214,196,178,160,142,124),
            c(252,235,219,202,185,168,152,135),maxColorValue=255),
		rgb(c(244,222,200,178,157,135,113, 91, 69),
            c(250,232,214,196,178,160,142,124,106),
            c(252,235,219,202,185,168,152,135,118),maxColorValue=255)
        ),
    sPBIOr = switch(n-2,
		rgb(c(253,237,222),
            c(245,224,203),
            c(241,217,194),maxColorValue=255),
		rgb(c(253,237,222,206),
            c(245,224,203,181),
            c(241,217,194,170),maxColorValue=255),
		rgb(c(253,237,222,206,190),
            c(245,224,203,181,160),
            c(241,217,194,170,146),maxColorValue=255),
		rgb(c(253,237,222,206,190,174),
            c(245,224,203,181,160,139),
            c(241,217,194,170,146,122),maxColorValue=255),
		rgb(c(253,237,222,206,190,174,159),
            c(245,224,203,181,160,139,118),
            c(241,217,194,170,146,122, 99),maxColorValue=255),
		rgb(c(253,237,222,206,190,174,159,143),
            c(245,224,203,181,160,139,118, 96),
            c(241,217,194,170,146,122, 99, 75),maxColorValue=255),
	    rgb(c(253,237,222,206,190,174,159,143,127),
            c(245,224,203,181,160,139,118, 96, 75),
            c(241,217,194,170,146,122, 99, 75, 51),maxColorValue=255)
        ),
    sPBIPu =  switch(n-2,
	    rgb(c(246,226,205),
            c(241,218,194),
            c(245,224,203),maxColorValue=255),
	    rgb(c(246,226,205,185),
            c(241,218,194,171),
            c(245,224,203,182),maxColorValue=255),
	    rgb(c(246,226,205,185,165),
            c(241,218,194,171,147),
            c(245,224,203,182,161),maxColorValue=255),
	    rgb(c(246,226,205,185,165,144),
            c(241,218,194,171,147,124),
            c(245,224,203,182,161,140),maxColorValue=255),
	    rgb(c(246,226,205,185,165,144,124),
            c(241,218,194,171,147,124,100),
            c(245,224,203,182,161,140,119),maxColorValue=255),
	    rgb(c(246,226,205,185,165,144,124,103),
            c(241,218,194,171,147,124,100, 77),
            c(245,224,203,182,161,140,119, 98),maxColorValue=255),
	    rgb(c(246,226,205,185,165,144,124,103, 83),
            c(241,218,194,171,147,124,100, 77, 53),
            c(245,224,203,182,161,140,119, 98, 77),maxColorValue=255)
        ),
    sPBIYlGn =  switch(n-2,
        rgb(c(250,219,188),
            c(233,215,198),
            c(160,151,141),maxColorValue=255),
        rgb(c(250,219,188,156),
            c(233,215,198,180),
            c(160,151,141,132),maxColorValue=255),
        rgb(c(250,219,188,156,125),
            c(233,215,198,180,163),
            c(160,151,141,132,123),maxColorValue=255),
        rgb(c(250,219,188,156,125, 94),
            c(233,215,198,180,163,145),
            c(160,151,141,132,123,113),maxColorValue=255),
        rgb(c(250,219,188,156,125, 94, 63),
            c(233,215,198,180,163,145,127),
            c(160,151,141,132,123,113,104),maxColorValue=255),
        rgb(c(250,219,188,156,125, 94, 63, 31),
            c(233,215,198,180,163,145,127,110),
            c(160,151,141,132,123,113,104, 94),maxColorValue=255),
        rgb(c(250,219,188,156,125, 94, 63, 31,  0),
            c(233,215,198,180,163,145,127,110, 92),
            c(160,151,141,132,123,113,104, 94, 85),maxColorValue=255)
        ),
    sPBIRdPu = switch(n-2,
        rgb(c(254,233,211),
            c(192,175,157),
            c(191,177,163),maxColorValue=255),
        rgb(c(254,233,211,190),
            c(192,175,157,140),
            c(191,177,163,148),maxColorValue=255),
        rgb(c(254,233,211,190,169),
            c(192,175,157,140,123),
            c(191,177,163,148,134),maxColorValue=255),
        rgb(c(254,233,211,190,169,147),
            c(192,175,157,140,123,105),
            c(191,177,163,148,134,120),maxColorValue=255),
        rgb(c(254,233,211,190,169,147,126),
            c(192,175,157,140,123,105, 88),
            c(191,177,163,148,134,120,106),maxColorValue=255),
        rgb(c(254,233,211,190,169,147,126,104),
            c(192,175,157,140,123,105, 88, 70),
            c(191,177,163,148,134,120,106, 91),maxColorValue=255),
	    rgb(c(254,233,211,190,169,147,126,104, 83),
            c(192,175,157,140,123,105, 88, 70, 53),
            c(191,177,163,148,134,120,106, 91, 77),maxColorValue=255)
        )
	)
}

#' @importFrom grDevices rgb
#' @export
display.redmonder.pal<-function(n,name){
   if(!(name %in% namelist)){
   stop(paste(name,"is not a valid palette name for redmonder.pal\n"))
   }
   if(n<3){
   warning("minimal value for n is 3, displaying requested palette with 3 different levels\n")
   return(display.redmonder.pal(3,name))
   }
   if(n>maxcolors[which(name==namelist)]){
   warning(paste("n too large, allowed maximum for palette",name,"is",maxcolors[which(name==namelist)]),
        "\nDisplaying the palette you asked for with that many colors\n")
   return(display.redmonder.pal(maxcolors[which(name==namelist)],name))
   }


   if(length(which(name==quallist))>0) palattr<-"(qualitative)"
   if(length(which(name==divlist))>0) palattr<-"(divergent)"
   if(length(which(name==seqlist))>0) palattr<-"(sequential)"
    image(1:n,1,as.matrix(1:n),col=redmonder.pal(n,name),
       xlab=paste(name,palattr),ylab="",xaxt="n",yaxt="n",bty="n")

}

#' @importFrom graphics image par plot rect text
#' @export
display.redmonder.all <-
    function (n=NULL, type="all", select=NULL, exact.n=TRUE, colorblindFriendly=FALSE) {
	gaplist <- ""

    totallist <- c(divlist, gaplist, quallist, gaplist, seqlist)
	names(totallist) <- c(names(divlist),"gap1",names(quallist),"gap2",names(seqlist))
    gapnum <- max(c(divnum,qualnum,seqnum))
    totnum <- c(divnum, gapnum, qualnum, gapnum, seqnum)
	names(totnum) <- names(totallist)

    if (!(type %in% c("div","qual","seq","all"))) {
        stop(paste(type, "is not a valid name for a color list\n"))
    }
    colorlist <- switch(type, div=divlist,
                        qual=quallist, seq=seqlist,
                        all=totallist)
    maxnum <- switch(type, div=divnum,
                     qual=qualnum,
                     seq=seqnum,
                     all=totnum)
    if(!is.null(select)){colorlist <- colorlist[select]
                         maxnum <- maxnum[select]
                         if(any(is.na(colorlist)))
                             stop(paste("Illegal value(s) of select: ",
                                        paste(select[is.na(colorlist)],
                                              collapse=" ")))
                     }

	if (colorblindFriendly) {
		colorlist <- colorlist[names(colorlist) %in% c(colorblindlist,"gap1","gap2")]
		maxnum <- maxnum[names(maxnum) %in% c(colorblindlist,"gap1","gap2")]
	}





    palattr <-  switch(type,  qual="qualitative",  div
                       ="divergent", seq="sequential",
                       all="qualitative+divergent+sequential")

    if(is.null(n))n <- maxnum
    if(length(n)==1)n <- rep(n, length(colorlist))

    if(exact.n){
        keep <- n<=maxnum
        colorlist <- colorlist[keep]
        n <- n[keep]
        maxnum <- maxnum[keep]
    }



    if (any(n < 3) | exact.n & any(n>maxnum)|
        length(n)!=length(colorlist)){
        warning("Illegal vector of color numbers")
        print(paste(n, collapse=" "))
    }
    n[n<3] <- 3
    n[n>maxnum] <- maxnum[n>maxnum]

    nr <- length(colorlist)
    nc <- max(n)

    ylim <- c(0,nr)
    oldpar <- par(mgp=c(2,0.25,0))
    on.exit(par(oldpar))
    plot(1,1,xlim=c(0,nc),ylim=ylim,type="n", axes=FALSE, bty="n",
         xlab="",ylab="")
    for(i in 1:nr)
    {nj <- n[i]
     if (colorlist[i]=="") next
     shadi <- redmonder.pal(nj, colorlist[i])
     rect(xleft=0:(nj-1), ybottom=i-1, xright=1:nj, ytop=i-0.2, col=shadi,
          border="light grey")
 }
    text(rep(-0.1,nr),(1:nr)-0.6, labels=colorlist, xpd=TRUE, adj=1)
}
