% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dMW.R
\name{dMW}
\alias{dMW}
\alias{pMW}
\alias{qMW}
\alias{rMW}
\alias{hMW}
\title{The Modified Weibull distribution}
\usage{
dMW(x, mu, sigma, nu, log = FALSE)

pMW(q, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

qMW(p, mu, sigma, nu, lower.tail = TRUE, log.p = FALSE)

rMW(n, mu, sigma, nu)

hMW(x, mu, sigma, nu)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{shape parameter one.}

\item{sigma}{parameter two.}

\item{nu}{scale parameter three.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dMW} gives the density, \code{pMW} gives the distribution 
function, \code{qMW} gives the quantile function, \code{rMW}
generates random deviates and \code{hMW} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for the modified weibull distribution 
with parameters \code{mu}, \code{sigma} and \code{nu}.
}
\details{
The modified weibull distribution with parameters \code{mu}, \code{sigma}
and \code{nu} has density given by

\eqn{f(x) = \mu (\sigma + \nu x) x^{\sigma - 1} \exp(\nu x) \exp(-\mu x^{\sigma} \exp(\nu x))}

for \eqn{x > 0}, \eqn{\mu > 0}, \eqn{\sigma \geq 0} and \eqn{\nu \geq 0}.
}
\examples{
old_par <- par(mfrow = c(1, 1)) # save previous graphical parameters

## The probability density function 
curve(dMW(x, mu=2, sigma=1.5, nu=0.2), from=0, to=2,
  ylim=c(0, 1.5), col="red", las=1, ylab="f(x)")

## The cumulative distribution and the Reliability function
par(mfrow = c(1, 2))
curve(pMW(x, mu=2, sigma=1.5, nu=0.2), from=0, to=2,
 col = "red", las=1, ylab="F(x)")
curve(pMW(x, mu=2, sigma=1.5, nu=0.2, lower.tail = FALSE), 
from=0, to=2, col="red", las=1, ylab ="R(x)")

## The quantile function
p <- seq(from=0, to=0.9999, length.out=100)
plot(x=qMW(p, mu=2, sigma=1.5, nu=0.2), y=p, xlab="Quantile",
 las=1, ylab="Probability")
curve(pMW(x, mu=2, sigma=1.5, nu=0.2), from=0, add=TRUE, col="red")

## The random function
hist(rMW(n=1000, mu=2, sigma=1.5, nu=0.2), freq=FALSE,
 xlab="x", las=1, main="")
curve(dMW(x, mu=2, sigma=1.5, nu=0.2), from=0, add=TRUE, col="red")

## The Hazard function
par(mfrow=c(1,1))
curve(hMW(x, mu=2, sigma=1.5, nu=0.2), from=0, to=1.5, ylim=c(0, 5),
 col="red", las=1, ylab="H(x)", las=1)

par(old_par) # restore previous graphical parameters
}
\references{
\insertRef{almalki2014modifications}{RelDists}

\insertRef{lai2003modified}{RelDists}
}
\author{
Johan David Marin Benjumea, \email{johand.marin@udea.edu.co}
}
