% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reparto_Escanos.R
\name{Restos_Mayores}
\alias{Restos_Mayores}
\title{Largest remainder method}
\usage{
Restos_Mayores(partidos, votos, escanos, metodo = "Hare")
}
\arguments{
\item{partidos}{A character vector containing the name of the parties.}

\item{votos}{An integer vector with the votes of each party.}

\item{escanos}{An integer number containing the total number of seats to be allocated.}

\item{metodo}{This is the method to be used. The allowed values are: "Hare", "Droop",
"Imperiali", "Mod_Imperiali", "hangenbach-bischo". The default value is "Hare".}
}
\value{
A dataframe with the political parties and the votes assigned to each.
}
\description{
This function is used to translate votes into seats,
following the criterion called "Largest Remains". In summary, this method is
calculated as follows: the total number of votes is divided by the total number of seats
(cost of each seat). The votes of each party are then divided by the above
ratio. The integer part of the above results are taken, which will be the
initial seats for each party. The remaining seats to be distributed are
allocated to the parties with the largest remainders (see https://en.wikipedia.org/wiki/Largest_remainder_method ).

The cost of each seat is what differentiates one method from another. Thus
if n is the total number of seats and m the sum of all votes, the denomination
of the methods is as follows, depending on the ratio that is taken:

\enumerate{
\item \bold{Hare (Hare)}: q=m/n
\item \bold{Droop (Droop)}:q=1+(m/(1+n))
\item \bold{Imperiali (Imperiali)}: q=m/(n+2)
\item \bold{Imperiali modificado (Mod_Imperiali)}: q=m/(n+3)
\item \bold{Hangenbach Bischof (hangenbach-bischo)}: q=m/(n+1)
}

In all cases the value of q is rounded to the nearest integer.
}
\examples{
Restos_Mayores(c("A","B","C","D","E","F","G"),
 c(391000,311000,184000,73000,27000,12000,2000),
 21,metodo = "Imperiali")

}
\seealso{
\code{\link{reparto_div}} for the allocation using divisor method

\url{https://en.wikipedia.org/wiki/Largest_remainder_method} on Wikipedia.

\code{\link{reparto_div}}
}
