% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rGLS.R
\name{rGLS}
\alias{rGLS}
\title{GWAS for Studies having Repeated Measurements on Related Individuals}
\usage{
rGLS(
  formula.FixedEffects = y ~ 1,
  genabel.data,
  phenotype.data,
  id.name = "id",
  GRM = NULL,
  V = NULL,
  memory = 1e+08,
  verbose = TRUE
)
}
\arguments{
\item{formula.FixedEffects}{Formula including the response variable and cofactors as fixed effects.}

\item{genabel.data}{A GenABEL-like object including marker information. This object has one observation per individuals.}

\item{phenotype.data}{A data frame including the repeated observations and IDs.}

\item{id.name}{The column name of the IDs in phen.data}

\item{GRM}{An optional genetic relationship matrix (GRM) can be included as input. Otherwise the GRM is computed within the function.}

\item{V}{An optional (co)variance matrix can be included as input. Otherwise it is computed using the hglm function.}

\item{memory}{Used to optimize computations. The maximum number of elements in a matrix that can be stored efficiently.}

\item{verbose}{If TRUE the progress of the computations is printed.}
}
\value{
Returns a gwaa.scan2-object.
}
\description{
It is used to perform genome-wide association studies on individuals that are both related and have repeated measurements.
The function computes score statistic based p-values for a linear mixed model including random polygenic effects and
a random effect for repeated measurements. A p-value is computed for each marker and the null hypothesis tested is a
zero additive marker effect.
}
\details{
A generalized squares (GLS) is fitted for each marker given a (co)variance matrix V.
The computations are made fast by transforming the GLS to
an ordinary least-squares (OLS) problem using an eigen-decomposition of V.
The OLS are computed using QR-factorization. If V is not specified then a model
including random polygenic effects and permanent environmental effects is
fitted (using the hglm package) to compute V. A GenABEL-like object (scan.gwaa2 class)
is returned (including also the \code{hglm} results).
Let e.g. GWAS1 be an object returned by the \code{rGLS} function.
Then a Manhattan plot can be produced by calling \code{plot(GWAS1)} and
the top SNPs using \code{summary(GWAS1)}.  \cr
The results from the fitted linear mixed model without any SNP effect included
are produced by calling \code{summary(GWAS1@call$hglm)}.
}
\examples{
 set.seed(1234)
 Gen.Data <- simulate_gendata(n=100, p=200)
 Phen.Data <- simulate_PhenData(y ~ 1, genabel.data=Gen.Data,
                               n.obs=rep(4, nids(Gen.Data)), SNP.eff=2, SNP.nr=100, VC=c(1,1,1))
 GWAS1 <- rGLS(y ~ 1, genabel.data = Gen.Data, phenotype.data = Phen.Data)
 plot(GWAS1, main="")
 summary(GWAS1)
 #Summary for variance component estimation without SNP effects
 summary(GWAS1@call$hglm)

}
\author{
Lars Ronnegard
}
