% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResIN_boots_execute.R
\name{ResIN_boots_execute}
\alias{ResIN_boots_execute}
\title{Carry out prepared bootstrap analyses on ResIN networks}
\usage{
ResIN_boots_execute(
  ResIN_boots_prepped,
  parallel = FALSE,
  detect_cores = TRUE,
  core_offset = 0L,
  n_cores = 2L,
  inorder = FALSE
)
}
\arguments{
\item{ResIN_boots_prepped}{A \code{"ResIN_boots_prepped"} bootstrap plan (output of \code{\link{ResIN_boots_prepare}}).}

\item{parallel}{Should execution use parallelism via \code{foreach} + a PSOCK cluster? Defaults to FALSE.}

\item{detect_cores}{Should available CPU cores be detected automatically? Defaults to TRUE (ignored when \code{parallel = FALSE}).}

\item{core_offset}{Integer offset subtracted from the number of detected cores. Defaults to 0L.}

\item{n_cores}{Manually specify number of cores (ignored if \code{detect_cores = TRUE} or \code{parallel = FALSE}).}

\item{inorder}{Should parallel execution preserve sequential ordering? Defaults to FALSE.}
}
\value{
An object of class \code{"ResIN_boots_executed"} containing \code{n} bootstrapped
\code{ResIN} fits. Use \code{print()}, \code{summary()}, \code{length()}, and \code{[}
to inspect or subset results. See \code{\link{ResIN_boots_executed}} for details.
}
\description{
Executes a bootstrap plan created by \code{\link{ResIN_boots_prepare}} by repeatedly
re-estimating ResIN on resampled or permuted versions of the original data.
Can optionally leverage CPU parallelism.
}
\examples{
## Load the 12-item simulated Likert-type toy dataset
data(lik_data)

# Apply the ResIN function to toy Likert data:
ResIN_obj <- ResIN(lik_data, network_stats = TRUE,
                      generate_ggplot = FALSE, plot_ggplot = FALSE)

\donttest{
# Prepare for bootstrapping
prepped_boots <- ResIN_boots_prepare(ResIN_obj, n=100, boots_type="resample")

# Execute the prepared bootstrap list
executed_boots <-  ResIN_boots_execute(prepped_boots, parallel = TRUE, detect_cores = TRUE)

# Extract results - here for example, the network (global)-clustering coefficient
ResIN_boots_extract(executed_boots, what = "global_clustering", summarize_results = TRUE)
}

}
