% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ResIN.R
\name{as.graphsjl.ResIN}
\alias{as.graphsjl.ResIN}
\title{Export a ResIN object to Graphs.jl (Julia) tables}
\usage{
\method{as.graphsjl}{ResIN}(
  x,
  file = "ResIN_graphsjl.csv",
  edges_only = TRUE,
  dont_save_csv = FALSE,
  weight_col = "weight",
  ...
)
}
\arguments{
\item{x}{A \code{ResIN} object.}

\item{file}{Output file name (legacy style). If \code{edges_only = TRUE},
the edge table is written to \code{file}. If \code{edges_only = FALSE},
\code{file} is treated as a prefix and \code{"_edges.csv"} /
\code{"_nodes.csv"} are appended (with any trailing \code{.csv} removed).}

\item{edges_only}{Logical; if TRUE (default), only write/return edge table.}

\item{dont_save_csv}{Logical; if FALSE (default), write CSV output. If TRUE,
no files are written and the resulting table(s) are returned visibly.}

\item{weight_col}{Preferred edge-weight column name. Defaults to \code{"weight"}.}

\item{...}{Ignored.}
}
\value{
If \code{edges_only = TRUE}, an edge table \code{data.frame}.
  Otherwise a list with elements \code{edges} and \code{nodes}. The node table
  includes integer \code{vertex_id} values and preserved node metadata.
}
\description{
Produces Graphs.jl-style edge (and optionally node) tables from a \code{ResIN}
object. Edge endpoints are mapped to integer vertex IDs (\code{src}, \code{dst})
to align with \pkg{Graphs.jl} in Julia. Node and edge metadata are preserved as table
columns. The node table stores the vertex mapping and additional ResIN metadata.
}
\examples{
\dontrun{
data(lik_data)
res <- ResIN(lik_data, generate_ggplot = FALSE, plot_ggplot = FALSE)

# Return tables only (no files written)
jl_tbls <- as.graphsjl(res, dont_save_csv = TRUE, edges_only = FALSE)

# Default behavior writes CSV files
# as.graphsjl(res, file = "ResIN_graphsjl.csv", edges_only = FALSE)
}

}
