% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ResIN.R
\name{as.network.ResIN}
\alias{as.network.ResIN}
\title{Convert a ResIN object to a statnet/network object}
\usage{
\method{as.network}{ResIN}(x, directed = FALSE, loops = FALSE, multiple = FALSE, ...)
}
\arguments{
\item{x}{A \code{ResIN} object.}

\item{directed}{Logical; should the resulting network be directed?
Defaults to \code{FALSE}.}

\item{loops}{Logical; allow self-loops? Defaults to \code{FALSE}.}

\item{multiple}{Logical; allow multiple edges? Defaults to \code{FALSE}.}

\item{...}{Additional arguments passed to \code{network::as.network()}.}
}
\value{
An object of class \code{network}.
}
\description{
Coerces a \code{ResIN} object to a \code{network} object (from the
\pkg{network} package used in the \pkg{statnet} ecosystem). The method
preserves edge-level columns from \code{x$ResIN_edgelist} as edge attributes
and node-level columns from \code{x$ResIN_nodeframe} as vertex attributes
whenever available.
}
\examples{
data(lik_data)
res <- ResIN(lik_data, generate_ggplot = FALSE, plot_ggplot = FALSE)

# ResIN re-exports network::as.network()
net <- as.network.ResIN(res) ## alternatively: as.network(res)
class(net)

}
