% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ResIN.R
\name{as.qgraph.ResIN}
\alias{as.qgraph.ResIN}
\title{Coerce a ResIN object to a qgraph object}
\usage{
\method{as.qgraph}{ResIN}(
  x,
  layout = "spring",
  maximum = 1,
  vsize = 6,
  DoNotPlot = TRUE,
  sampleSize = NULL,
  title = "ResIN graph in qgraph",
  mar = c(3, 8, 3, 8),
  normalize = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{ResIN} object.}

\item{layout, maximum, vsize, DoNotPlot, sampleSize, title, mar, normalize}{Passed to \code{qgraph::qgraph()}.}

\item{...}{Additional arguments passed to \code{qgraph::qgraph()}.}
}
\value{
A \code{qgraph} object.
}
\description{
Converts a \code{ResIN} object to a \code{qgraph} object using the adjacency
matrix stored in \code{x$aux_objects$adj_matrix}.
}
\examples{
## Load the 12-item simulated Likert-type ResIN toy dataset
data(lik_data)

## Run the function:
ResIN_qgraph <-  as.qgraph(ResIN(lik_data, plot_ggplot = FALSE))

class(ResIN_qgraph)

}
