% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Router.R
\name{Router}
\alias{Router}
\title{Creates Router object.}
\description{
Creates Router object.
}
\examples{
r = RestRserve:::Router$new()
r$add_path("/test", "exact", "testid")
r$add_path("/area", "partial", "areaid")
r$add_path("/template/{variable}", "regex", "templateid")
r$match_path("/test") # testid
r$match_path("/area/entry") # areaid
r$match_path("/template/12345") # templateid
attr(r$match_path("/template/12345"), "parameters_path") # variables values

}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{paths}}{All added paths as is (with templates placeholders).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Router-new}{\code{Router$new()}}
\item \href{#method-Router-size}{\code{Router$size()}}
\item \href{#method-Router-add_path}{\code{Router$add_path()}}
\item \href{#method-Router-match_path}{\code{Router$match_path()}}
\item \href{#method-Router-clone}{\code{Router$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Router-new"></a>}}
\if{latex}{\out{\hypertarget{method-Router-new}{}}}
\subsection{Method \code{new()}}{
Creates Router object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Router-size"></a>}}
\if{latex}{\out{\hypertarget{method-Router-size}{}}}
\subsection{Method \code{size()}}{
Returns number of paths added before.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Number of paths.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Router-add_path"></a>}}
\if{latex}{\out{\hypertarget{method-Router-add_path}{}}}
\subsection{Method \code{add_path()}}{
Add path with their id.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$add_path(path, match = c("exact", "partial", "regex"), id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to handle.}

\item{\code{match}}{Defines how route will be processed. Allowed values:
\itemize{
\item \code{exact} - match route as is. Returns 404 if route is not matched.
\item \code{partial} - match route as prefix. Returns 404 if prefix are not matched.
\item \code{regex} - match route as template. Returns 404 if template pattern not matched.
}}

\item{\code{id}}{Path handler id.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Router-match_path"></a>}}
\if{latex}{\out{\hypertarget{method-Router-match_path}{}}}
\subsection{Method \code{match_path()}}{
Find path within paths added before. Returns \code{NULL} if path not matched.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$match_path(path, extract_vars = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path endpoint.}

\item{\code{extract_vars}}{Extart path parameters (when handler matches regex).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Handler id.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Router-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Router-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Router$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
