% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPostPredStats.R
\name{plotPostPredStats}
\alias{plotPostPredStats}
\title{plot Posterior Predictive Statistics}
\usage{
plotPostPredStats(
  data,
  prob = c(0.9, 0.95),
  col = NULL,
  side = "both",
  type = "strict",
  PPES = FALSE,
  ...
)
}
\arguments{
\item{data}{(list of data frames; no default) A list of data frames
of the empirical and simulated values, such as the output of
processPostPredStats.R}

\item{prob}{(vector of numerics; default c(0.9, 0.95)) The
posterior-predictive intervals to shade.}

\item{col}{(vector of colors; default NULL) The colors for each quantile.
Defaults to blue and red.}

\item{side}{(character; default "both") Whether the plotted/colored 
intervals are on "both" sides, the "left" side, or the "right" 
side of the distribution.}

\item{type}{(character; default "strict") Whether equal values are
considered as less extreme as the observed data ("strict") or half of the
equal values are considered to be higher and half to be lower ("midpoint")}

\item{PPES}{(boolean; default FALSE) Whether we provide the posterior
predictive effect size (PPES).}

\item{...}{Additional arguments are passed to stats::density().}
}
\value{
A list of ggplot objects, where each plot contains a density
distribution of the predicted values and a dashed line of the empirical
value. The blue shaded region of the density plot corresponds to the 5\%
two-sided quantile and the orange corresponds to the 2\% two-sided quantile.
}
\description{
Plots the posterior predictive statistics data
}
\details{
Produces one ggplot object per metric. Intended
to plot the results of the RevBayes tutorial:
Assessing Phylogenetic Reliability Using RevBayes and P3
Model adequacy testing using posterior prediction (Data Version).

Each plot shows the rejection region for the provided quantiles,
as well as a p-value for the observed statistic. If side="left" (or "right"),
then the p-value is the fraction of simulated statistics that are less than
( or greater than) or equal to the observed statistic. If side="both", then
the p-value is calculated by first fitting a KDE to the samples, then
computing the fraction of simulated statistics with density lower than the
density of he observed statistic; in this sense, the "both" option computes
the size of HPD defined by the observed statistic.
}
\examples{

\donttest{
# download the example datasets to working directory

url_emp <-
   "https://revbayes.github.io/tutorials/intro/data/empirical_data_pps_example.csv"
dest_path_emp <- "empirical_data_pps_example.csv"
download.file(url_emp, dest_path_emp)

url_sim <-
   "https://revbayes.github.io/tutorials/intro/data/simulated_data_pps_example.csv"
dest_path_sim <- "simulated_data_pps_example.csv"
download.file(url_sim, dest_path_sim)

# to run on your own data, change this to the path to your data file
file_sim <- dest_path_sim
file_emp <- dest_path_emp

t <- processPostPredStats(path_sim = file_sim,
                         path_emp = file_emp)
plots <- plotPostPredStats(data = t)
plots[[1]]

# remove files
# WARNING: only run for example dataset!
# otherwise you might delete your data!
file.remove(dest_path_sim, dest_path_emp)

}

}
