% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rgff.R
\name{check_gff}
\alias{check_gff}
\title{Test consistency and order of a GFF file}
\usage{
check_gff(inFile, fileType = c("AUTO", "GFF3", "GTF"))
}
\arguments{
\item{inFile}{Path to the input GFF file}

\item{fileType}{Version of the input file (GTF/GFF3). Default AUTO: determined from the file name.}
}
\value{
A data frame of detected issues, including a short code name, a description and estimated severity each. In no issues are detected the function will return an empty data frame.
}
\description{
This function tests the consistency and order of a GFF file.
}
\details{
The following list indicates the code and description of the issues detected in GFF3 files
\describe{
\item{NCOLUMNS_EXCEEDED}{Input file contains lines with more than 9 fields}
\item{NCOLUMNS_INFERIOR}{Input file contains lines with less than 9 fields}
\item{TOO_MANY_FEATURE_TYPES}{Input file contains too many (more than 100) different feature types}
\item{NO_IDs}{ID attribute not found in any feature}
\item{DUPLICATED_IDs}{There are duplicated IDs}
\item{ID_IN_MULTIPLE_CHR}{The same ID has been found in more than one chromosome}
\item{NO_PARENTs}{Parent attribute not found in any feature}
\item{MISSING_PARENT_IDs}{There are  missing Parent IDs}
\item{PARENT_IN DIFFERENT CHR}{There are features whose Parent is located in a different chromosome}
\item{PARENT_DEFINED_BEFORE_ID}{Feature ids referenced in Parent attribute before being defined as ID}
\item{NOT_GROUPED_BY_CHR}{Features are not grouped by chromosome}
\item{NOT_SORTED_BY_COORDINATE}{Features are not sorted by start coordinate}
\item{NOT_VALID_WARNING}{File cannot be recognized as valid  GFF3. Parsing warnings.}
\item{NOT_VALID_ERROR}{File cannot be recognized as valid GFF3. Parsing errors.}
}
The following list indicates the code and description of the issues detected in GTF files
\describe{
\item{NCOLUMNS_EXCEEDED}{Input file contains lines with more than 9 fields}
\item{NCOLUMNS_INFERIOR}{Input file contains lines with less than 9 fields}
\item{TOO_MANY_FEATURE_TYPES}{Input file contains too many (more than 100) different feature types}
\item{NO_GENE_ID_ATTRIBUTE}{gene_id attribute not found in any feature}
\item{MISSING_GENE_IDs}{There are features without gene_id attribute}
\item{NO_GENE_FEATURES}{Gene features are not included in this GTF file}
\item{DUPLICATED_GENE_IDs}{There are duplicated gene_ids }
\item{GENE_ID_IN_MULTIPLE_CHR}{The same gene_id has been found in more than one chromosome}
\item{NO_TRANSCRIPT_ID_ATTRIBUTE}{transcript_id attribute not found in any feature There are no elements with transcript_id attribute}
\item{MISSING_TRANSCRIPT_IDs}{There are  features without transcript_id attribute}
\item{NO_TRANSCRIPT_FEATURES}{Transcript features are not included in this GTF file}
\item{DUPLICATED_TRANSCRIPT_IDs}{There are  duplicated transcript_ids }
\item{TRANSCRIPT_ID_IN_MULTIPLE_CHR}{The same transcript_id has been found in more than one chromosome}
\item{DUPLICATED_GENE_AND_TRANSCRIPT_IDs}{Same id has been defined as gene_id and transcript_id}
\item{NOT_GROUPED_BY_CHR}{Features are not grouped by chromosome}
\item{NOT_SORTED_BY_COORDINATE}{Features are not sorted by start coordinate}
\item{NOT_VALID_WARNING}{File cannot be recognized as valid GTF. Parsing warnings.}
\item{NOT_VALID_ERROR}{File cannot be recognized as valid GTF. Parsing errors.}
}
}
\examples{
test_gff3<-system.file("extdata", "eden.gff3", package="Rgff")
check_gff(test_gff3)
}
