% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantileAnalysis.R
\name{QuantileAnalysis}
\alias{QuantileAnalysis}
\title{Quantile Effect Analysis}
\usage{
QuantileAnalysis(S, C, Z, R, quantile = 0.5, delta_hyp = 0)
}
\arguments{
\item{S}{A numeric column vector with individuals' stratum number}

\item{C}{A numeric column vector with individuals' cluster number}

\item{Z}{A numeric column vector with individuals' treatment assignment
(binary)}

\item{R}{A numeric column vector with individuals' outcome}

\item{quantile}{A numeric value for intended quantile in the input data for
running the quantile test, the default of this value is 0.5.}

\item{delta_hyp}{A numeric value that is the hypothesized treatment effect
given the quantile. The default of this value is 0.}
}
\value{
A list of the outputs
}
\description{
A function for quantile analysis that provides a p-value and a point estimation.
}
\examples{
# First we need to obtain the vectors for the inputs.
S = example1$S
C = example1$C
Z = example1$Z
R = example1$R
\donttest{QuantileAnalysis(S, C, Z, R)}
}
