% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-harmo_process_harmonization.R
\name{is_data_proc_elem}
\alias{is_data_proc_elem}
\title{Test for a valid Data Processing Elements object}
\usage{
is_data_proc_elem(object)
}
\arguments{
\item{object}{A potential Data Processing Elements object to be evaluated.}
}
\value{
A logical.
}
\description{
Tests if the input is a valid Data Processing Elements object. This function
mainly helps validate input within other functions of the package but could
be used to check if an object is valid for use in a function.
}
\details{
The Data Processing Elements specifies the input elements and processing algorithms
to generate harmonized variables in the DataSchema formats. It is also
contains metadata used to generate documentation of the processing.
A Data Processing Elements object is a data frame with specific columns
used in data processing: \code{dataschema_variable}, \code{input_dataset},
\code{input_variables}, \code{Mlstr_harmo::rule_category} and \code{Mlstr_harmo::algorithm}.
To initiate processing, the first entry must be the creation of a harmonized
primary identifier variable (e.g., participant unique ID).
}
\examples{
{

# Use Rmonize_examples to run examples.

is_data_proc_elem(Rmonize_examples$`Data_Processing_Elements_no_errors`)
is_data_proc_elem(Rmonize_examples$`DataSchema`)
is_data_proc_elem(iris)
}

}
