# Robust Mixture Regression



<!-- badges: start -->

[![License](http://img.shields.io/badge/license-GPL%20v3-orange.svg?style=flat)](http://www.gnu.org/licenses/gpl-3.0.en.html)
[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version-ago/RobMixReg)](https://CRAN.R-project.org/package=RobMixReg)
[![cran checks](https://cranchecks.info/badges/worst/RobMixReg)](https://CRAN.R-project.org/web/checks/check_results_RobMixReg.html)
[![Total Downloads](https://cranlogs.r-pkg.org/badges/grand-total/RobMixReg)](https://cran.r-project.org/package=RobMixReg)
[![documentation](https://github.com/laresbernardo/lares/workflows/documentation/badge.svg)](https://CRAN.R-project.org/package=RobMixReg/RobMixReg.pdf)
[![travis](https://travis-ci.com/laresbernardo/lares.svg?branch=master)](https://travis-ci.org/github/changwn/RobMixReg)
[![Hi](https://img.shields.io/badge/say-hi-blue.svg)](https://changwn.github.io/)

<!-- badges: end -->
<!--   ![Download](https://cranlogs.r-pkg.org/badges/RobMixReg)   -->




# Install from CRAN
```
install.packages("RobMixReg)
library("RobMixReg")
```

# Install from github for most updated package. 
#### Please report the bug as the description in the Question&Problem.
```
library("devtools")
devtools::install_github("changwn/RobMixReg")
```

# Tutorial

A comprehensive and complete tutorial is [here](https://changwn.github.io/RobMixReg/articles/tutorial.html).

# News

The package version control is in [News.md](https://changwn.github.io/RobMixReg/news/index.html)



## Citations
If you find the code helpful in your resarch or work, please cite us.
```BibTex
@article{wennan2020cat,
  title={A New Algorithm using Component-wise Adaptive Trimming For Robust Mixture Regression},
  author={Chang, Wennan and Wan, Changlin and Zhou, Xinyu and Zhang, Chi and Cao, Sha},
  journal={arXiv preprint arXiv:2005.11599},
  year={2020}
}

@article{chang2020supervised,
  title={Supervised clustering of high dimensional data using regularized mixture modeling},
  author={Chang, Wennan and Wan, Changlin and Zang, Yong and Zhang, Chi and Cao, Sha},
  journal={arXiv preprint arXiv:2007.09720},
  year={2020}
}
```

# Questions & Problems

If you have any questions or problems, please feel free to open a new issue [here](https://github.com/changwn/RMR/issues). We will fix the new issue ASAP.  You can also email the maintainers and authors below.

- [Wennan Chang](https://changwn.github.io/)
(wnchang@iu.edu)

PhD candidate at [Biomedical Data Research Lab (BDRL)](https://zcslab.github.io/) , Indiana University School of Medicine


