% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Romeb-package.R, R/Romeb.R
\docType{package}
\name{Romeb}
\alias{Romeb-package}
\alias{Romeb}
\title{Romeb: Robust Median-Based Bayesian Growth Curve Modeling}
\usage{
Romeb(
  Missing_Type,
  data,
  time,
  seed,
  K = 0,
  chain = 1,
  Niter = 6000,
  burnIn = 3000
)
}
\arguments{
\item{Missing_Type}{Character; one of \code{MNAR}, \code{MAR},
\code{MCAR}, \code{no missing}.}

\item{data}{Matrix or data frame containing outcome columns (and
optionally auxiliary variables).}

\item{time}{Numeric vector of measurement times (e.g., c(0,1,2,3)).}

\item{seed}{Integer seed for reproducibility.}

\item{K}{Integer; number of auxiliary variables (default 0).}

\item{chain}{Integer; number of MCMC chains (default 1).}

\item{Niter}{Integer; iterations per chain (default 6000).}

\item{burnIn}{Integer; burn-in iterations (default 3000).}
}
\value{
An object of class \code{RomebResult} containing
\describe{
\item{quantiles}{posterior means, SDs and quantiles}
\item{geweke}{Geweke \emph{z}-scores}
\item{credible_intervals}{95\% equal-tail credible intervals}
\item{hpd_intervals}{95\% highest posterior density intervals}
\item{samps_full}{full \code{coda::mcmc.list} (including burn-in)}
}
}
\description{
Implements robust median-based Bayesian growth-curve models that handle
MCAR/MAR/MNAR missing-data mechanisms and complete data. Models are fitted
via \pkg{rjags}/JAGS and summarized with \pkg{coda}.

Fits a median-based Bayesian growth curve model under MCAR, MAR,
MNAR or complete-data assumptions.  If \code{K > 0} the first
\code{K} columns in \code{data} are treated as auxiliary variables.
}
\examples{
  set.seed(123)
  Y <- matrix(rnorm(300), 100, 3)
  fit <- Romeb("no missing", data = Y, time = c(0,1,2), seed = 123, K = 0,
               Niter = 6000, burnIn = 3000)
  print(fit)
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/DandanTang0/Romeb}
  \item Report bugs at \url{https://github.com/DandanTang0/Romeb/issues}
}

}
\author{
\strong{Maintainer}: Dandan Tang \email{tangdd20@gmail.com} (\href{https://orcid.org/0009-0007-3453-9660}{ORCID})

Authors:
\itemize{
  \item Xin Tong
}

}
