% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Discretization.R
\name{D.discretize.quantiles.RST}
\alias{D.discretize.quantiles.RST}
\title{The quantile-based discretization}
\usage{
D.discretize.quantiles.RST(decision.table, nOfIntervals = 4)
}
\arguments{
\item{decision.table}{an object inheriting from the \code{"DecisionTable"} class, which represents a decision system.
See \code{\link{SF.asDecisionTable}}.}

\item{nOfIntervals}{a positive integer giving the number of intervals.}
}
\value{
An object of a class \code{"Discretization"} which stores cuts for each conditional attribute.
        See \code{\link{D.discretization.RST}}.
}
\description{
This function implements unsupervised discretization into intervals containing similar number of instances ("quantile-based").
}
\details{
This approach belongs to a class of unsupervised discretization methods
since it does not consider the class labels. Each numeric attribute is divided in \code{k} intervals which contain approximately
the same number of data instances (objects).
Detailed information regarding this method can be found in (Dougherty et al, 1995).

It should be noted that the output of this function is an object of a class \code{"Discretization"}
which contains the cut values.
The function \code{\link{SF.applyDecTable}} has to be used in order to generate the new (discretized) decision table.
}
\examples{
#################################################################
## Example: Determine cut values and generate new decision table
#################################################################
data(RoughSetData)
wine.data <- RoughSetData$wine.dt
cut.values <- D.discretize.quantiles.RST(wine.data, nOfIntervals = 5)

## generate a new decision table
wine.discretized <- SF.applyDecTable(wine.data, cut.values)
dim(wine.discretized)
lapply(wine.discretized, unique)

}
\references{
J. Dougherty, R. Kohavi, and M. Sahami, "Supervised and Unsupervised Discretization of Continuous Features",
In A. Prieditis & S. J. Russell, eds. Work. Morgan Kaufmann, p. 194-202 (1995).
}
\seealso{
\code{\link{D.discretize.equal.intervals.RST}}, \code{\link{D.global.discernibility.heuristic.RST}},
         \code{\link{D.local.discernibility.heuristic.RST}}, \code{\link{SF.applyDecTable}}.
         A wrapper function for all available discretization methods: \code{\link{D.discretization.RST}}
}
\author{
Andrzej Janusz
}
