% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crystal.R
\name{crystal}
\alias{crystal}
\alias{cryst1}
\alias{crystal.default}
\alias{is.cryst1}
\alias{is.crystal}
\title{Create \sQuote{crystal} Object}
\usage{
cryst1(...)

\method{crystal}{default}(abc, abg = c(90, 90, 90), sgroup = "P1", ...)

is.cryst1(x)

is.crystal(x)
}
\arguments{
\item{\dots}{further arguments passed to or from other methods.}

\item{abc}{a numeric vector of length 3 containing the norms of the lattice
vectors a, b and c.}

\item{abg}{a numeric vector of length 3 containing the angles between the
lattice vectors \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}.}

\item{sgroup}{a character string giving the Hermann-Mauguin symbol of the
space group.}

\item{x}{an R object to be tested.}
}
\value{
Function \code{crystal} returns a list of class \sQuote{crystal} with the
following components:
\item{abc}{a numeric vector of length 3 containing the norms of the lattice
  vectors a, b and c.}
\item{abg}{a numeric vector of length 3 containing the angles between the
  lattice vectors \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}.}
\item{sgroup}{a character string giving the Hermann-Mauguin symbol of the space group.}

Function \code{is.crystal} returns TRUE if \code{x} is an object of class \sQuote{crystal}
  and FALSE otherwise.
}
\description{
Create an object of class \sQuote{crystal} containing the unit cell parameters
and the name of the space group to associate with an object of class 
\sQuote{pdb}. Note: the \sQuote{cryst1} class will be deprecated.
}
\details{
\code{crystal} is a generic function to create objects of class 
\sQuote{crystal}. The purpose of this class is to store CRYST1 records from 
PDB files which contain the unit cell parameters and the name of the space 
group of a molecular system stored in a PDB file. The default method of the 
\code{crystal} function creates an object of class \sQuote{crystal} from its 
different components, i.e.: \code{abc}, \code{abg} and \code{sgroup}. At 
least \code{abc} has to be specified. \cr\cr \code{is.crystal} tests if an 
object is of class \sQuote{crystal}, i.e. if it has a \dQuote{class} attribute 
equal to \code{crystal}.
}
\examples{
x <- crystal(abc = c(10, 10, 10), abg = c(90,90,90), sgroup = "P1")
is.crystal(x)
 
}
\seealso{
\code{\link{cell.coords}}, \code{\link{pdb}}
}
\keyword{classes}
