% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rprofet.R
\name{ScorecardProfet}
\alias{ScorecardProfet}
\title{Scorecard Builder}
\usage{
ScorecardProfet(
  object,
  id,
  target,
  GLModel,
  PDO = 100,
  BaseOdds = 10,
  BasePts = 1000,
  reverse = FALSE
)
}
\arguments{
\item{object}{A WOEProfet object or a Var_select object that containing dataframes with binned and WOE values.}

\item{id}{ID variable.}

\item{target}{A binary target variable.}

\item{GLModel}{A generalized linear model, glm object.}

\item{PDO}{Points to Double Odds.}

\item{BaseOdds}{Base Odds.}

\item{BasePts}{Base Points.}

\item{reverse}{Logical. If FALSE, higher points corresponds to a lower probability of being target.}
}
\value{
A scorecard dataframe.
}
\description{
Function that fits a logistic regression models and scores points for each bin and calculates observations' total score.
}
\examples{
mydata <- ISLR::Default
mydata$ID = seq(1:nrow(mydata)) ## make the ID variable
mydata$default<-ifelse(mydata$default=="Yes",1,0) ## Creating numeric binary target variable

binned <- BinProfet(mydata, id= "ID", target= "default", num.bins = 5) ## Binning variables

WOE_dat <- WOEProfet(binned, "ID","default", 3:5) ## WOE transformation of bins

md <- glm(default ~ student_WOE+balance_WOE+income_WOE, data=WOE_dat$WOE, family="binomial")
summary(md)

Score_dat <- ScorecardProfet(object=WOE_dat, id="ID", target="default", GLModel=md,
                                 PDO = 50, BaseOdds = 10, BasePts = 1000, reverse = FALSE)

Score_dat ## Less points means more likely to default
}
