\name{BLACKJACK}
\alias{BLACKJACK}
\title{Jackknife earthquake location
}
\description{Perform jackknife on earthquake location
  by eliminating stations.
}
\usage{
BLACKJACK(Ldat, vel)
}
\arguments{
  \item{Ldat}{event list
  }
  \item{vel}{Velocity model
} 
}
\details{Stations are eliminated, not rows.
}
\value{event list with pseudo values
}
\references{
  Iversen, E. S., and J. M. Lees (1996), A statistical technique for validating velocity models, Bull. Seismol. Soc. Am. 86(6), 1853-1862.
}
\author{
Jonathan M. Lees<jonathan.lees@unc.edu>
}
\note{
  events are located with P and S-wave arrivals,
  but code here should eliminate just stations.
}


\seealso{Vlocate, plotJACKLLZ
}
\examples{


###### lps=list of files names to be read

data(GH, package='RSEIS')

g1 = GH$pickfile
data(VELMOD1D, package='RSEIS')

vel= VELMOD1D

 w1 = which(!is.na(g1$STAS$lat))
         sec = g1$STAS$sec[w1]

         N = length(sec)
         Ldat =    list(
           name = g1$STAS$name[w1],
           sec = g1$STAS$sec[w1],
           phase = g1$STAS$phase[w1],
           lat=g1$STAS$lat[w1],
           lon = g1$STAS$lon[w1],
           z = g1$STAS$z[w1],
           err= g1$STAS$err[w1],
           yr = rep(g1$LOC$yr , times=N),
           jd = rep(g1$LOC$jd, times=N),
           mo = rep(g1$LOC$mo, times=N),
           dom = rep(g1$LOC$dom, times=N),
           hr =rep( g1$LOC$hr, times=N),
           mi = rep(g1$LOC$mi, times=N) )

B = BLACKJACK(Ldat, vel)

##  the code HiJACK
###  runs BLACKJACK on many pickfiles stored in files
###  COSOjack = HiJACK(lps, sta)
###   plotJACKLLZ(COSOjack, sta, proj)

}
\keyword{misc}
