% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testmlx.R
\name{testmlx}
\alias{testmlx}
\title{Statistical tests for model assessment}
\usage{
testmlx(
  project = NULL,
  tests = c("covariate", "randomEffect", "correlation", "residual"),
  plot = FALSE,
  adjust = "edf",
  n.sample = NULL
)
}
\arguments{
\item{project}{a Monolix project}

\item{tests}{a vector of strings: the list of tests to perform 
among c("covariate","randomEffect","correlation","residual")}

\item{plot}{FALSE/TRUE  display some diagnostic plots associated to the tests (default=FALSE)}

\item{adjust}{method to take into account the dependency of MCMC sample  c("edf","BH") (default="edf")}

\item{n.sample}{number of samples from the conditional distribution to be used (default = number of available samples in the project)}
}
\value{
a list of data frames and ggplot objects if plot=TRUE
}
\description{
Perform several statistical tests using the results of a Monolix run to assess the statistical
components of the model in use.
}
\details{
The tests used are:  
1) F-tests (or, equivalently, correlation tests) to evaluate the effect of each covariate 
on each parameter ("covariate"), 
2) correlation tests to assess the correlation structure of the random effects ("correlation"), 
3) Shapiro-Wilk and Miao-Gel-Gastwirth tests to assess, respectively the normality and the
symmetry of the distribution of the random effects (""randomEffect"), 
4) Shapiro-Wilk and Miao-Gel-Gastwirth tests to assess, respectively the normality and the
symmetry of the distribution of residual errors ("residual").

By default, the four tests are performed.

When several samples of the conditional distributions are used, two methods are proposed in order 
to take into the dependance of the samples for the Shapiro-Wilk and Miao-Gel-Gastwirth tests: 
"edf" computes an effective degrees of freedom, "BH" performs one test per replicates and adjust 
the smallest p-value using the Benjamini-Hochberg correction.
}
\examples{
\dontrun{
# RsmlxDemo2.mlxtran is a Monolix project for modelling the PK of warfarin using a PK model 
# with parameters ka, V, Cl.

#testmlx will perform statistical tests for the different component of the statistical model:
r1 <- testmlx(project="RsmlxDemo2.mlxtran")

#testmlx will perform statistical tests for the covariate model and the correlation model only.
r2 <- testmlx(project="RsmlxDemo2.mlxtran", tests=c("covariate","correlation"))
}

# See http://monolix.lixoft.com/rsmlx/testmlx/ for detailed examples of use of testmlx
# Download the demo examples here: http://monolix.lixoft.com/rsmlx/installation

}
