% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_functions.R
\name{tsEvaDetrendTimeSeries}
\alias{tsEvaDetrendTimeSeries}
\title{Detrend a Time Series}
\usage{
tsEvaDetrendTimeSeries(
  timeStamps,
  series,
  timeWindow,
  percent = NA,
  fast = TRUE
)
}
\arguments{
\item{timeStamps}{A vector of time stamps for the time series.}

\item{series}{The original time series.}

\item{timeWindow}{The size of the moving window used to calculate the trend.}

\item{percent}{The percentile value used to calculate the trend for extreme values. Default is NA.}

\item{fast}{A logical value indicating whether to print additional information. Default is FALSE.}
}
\value{
An object of class "tsTrend" with the following components:
\describe{
\item{\code{originSeries}}{The original time series}
\item{\code{detrendSeries}}{The detrended time series}
\item{\code{trendSeries}}{The trend component of the time series}
\item{\code{nRunMn }}{The number of data points in the moving window used to calculate the trend}
}
}
\description{
This function detrends a time series by subtracting the trend component from the original series.
}
\examples{
timeAndSeries <- ArdecheStMartin
timeStamps <- ArdecheStMartin[,1]
series  <- ArdecheStMartin[,2]
timeWindow <- 365*30
detrended <- tsEvaDetrendTimeSeries(timeStamps, series, timeWindow)
}
