% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{tsEvaPlotAllRLevelsGEV}
\alias{tsEvaPlotAllRLevelsGEV}
\title{tsEvaPlotAllRLevelsGEV}
\usage{
tsEvaPlotAllRLevelsGEV(
  nonStationaryEvaParams,
  stationaryTransformData,
  rlvmax,
  timeIndex,
  timeStamps,
  tstamps,
  trans,
  ...
)
}
\arguments{
\item{nonStationaryEvaParams}{A list of non-stationary evaluation parameters containing the GEV distribution parameters (epsilon, sigma, mu) and the time delta in years (dtSampleYears).}

\item{stationaryTransformData}{The stationary transformed data used for the analysis.}

\item{rlvmax}{The maximum return level data, including the return periods (haz.RP) and the actual return levels (QNS).}

\item{timeIndex}{The index of the time step used for analysis.}

\item{timeStamps}{The timestamps corresponding to the time steps in the analysis.}

\item{tstamps}{The timestamps used for labeling the plot.}

\item{trans}{The transformation used to fit the EVD, either "ori" (original) or "rev" (reverse).}

\item{...}{Additional optional arguments for customizing the plot.}
}
\value{
A plot object showing the relationship between return periods and return levels for the GEV distribution at different timesteps.
}
\description{
\code{tsEvaPlotAllRLevelsGEV} is a function that generates
a beam plot of return levels for a Generalized Extreme Value (GEV)
distribution based on the provided parameters and data.
The plot showcases the evolving relationship between return periods and
return levels through time, allowing for visual analysis of extreme events
and their probabilities.
}
\examples{
 # Example usage of TsEvaNs function
timeAndSeries <- ArdecheStMartin
#go from six-hourly values to daily max
timeAndSeries <- max_daily_value(timeAndSeries)
#keep only the 20 last years
yrs <- as.integer(format(timeAndSeries$date, "\%Y"))
tokeep <- which(yrs>=2000)
timeAndSeries <- timeAndSeries[tokeep,]
timeWindow <- 5*365 # 5 years
TSEVA_data <- TsEvaNs(timeAndSeries, timeWindow,
transfType = 'trendPeaks',tail = 'high')
nonStationaryEvaParams <- TSEVA_data[[1]]
stationaryTransformData <- TSEVA_data[[2]]
amax <- nonStationaryEvaParams[[1]]$parameters$annualMax
amaxID <- nonStationaryEvaParams[[1]]$parameters$annualMaxIndx
timeStamps <- stationaryTransformData$timeStamps
trendPeaks <- stationaryTransformData$trendSeries[amaxID]
stdPeaks <- stationaryTransformData$stdDevSeries[amaxID]
amaxCor <- (amax - trendPeaks) / stdPeaks
nYears <- length(amaxCor)
rlvlmax <- empdis(amaxCor, nYears)
rlvlmax$QNS <- amax[order(amax)]
rlvlmax$Idt <- stationaryTransformData$timeStamps[amaxID][order(amax)]
timeIndex <- 2
tstamps <- "Example Timestamps"
trans <- "ori"
# Call the function with the defined arguments
result <- tsEvaPlotAllRLevelsGEV(
  nonStationaryEvaParams, stationaryTransformData,
  rlvlmax, timeIndex, timeStamps, tstamps,
  trans)
result
}
\seealso{
\code{\link{tsEvaComputeReturnLevelsGEV}}
}
