% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{tsEvaPlotTransfToStatFromAnalysisObj}
\alias{tsEvaPlotTransfToStatFromAnalysisObj}
\title{tsEvaPlotTransfToStatFromAnalysisObj}
\usage{
tsEvaPlotTransfToStatFromAnalysisObj(
  nonStationaryEvaParams,
  stationaryTransformData,
  ...
)
}
\arguments{
\item{nonStationaryEvaParams}{A list of parameters for non-stationary
time series evaluation.}

\item{stationaryTransformData}{A list containing the transformed stationary data.}

\item{...}{Additional arguments to be passed to
the \code{\link{tsEvaPlotTransfToStat}} function.}
}
\value{
The plot object representing the converted stationary series.
}
\description{
\code{tsEvaPlotTransfToStatFromAnalysisObj}is a function that takes the
parameters of a non-stationary time series evaluation,
along with the transformed stationary data,
and plots the converted stationary series.
}
\examples{
# Example usage of TsEvaNs function
timeAndSeries <- ArdecheStMartin
#go from six-hourly values to daily max
timeAndSeries <- max_daily_value(timeAndSeries)
#keep only the 30 last years
yrs <- as.integer(format(timeAndSeries$date, "\%Y"))
tokeep <- which(yrs>=1990)
timeAndSeries <- timeAndSeries[tokeep,]
timeWindow <- 10*365 # 10 years
TSEVA_data <- TsEvaNs(timeAndSeries, timeWindow,
transfType = 'trendPeaks',tail = 'high')
# Define the required function argumentsnonStationaryEvaParams <- TSEVA_data[[1]]
stationaryTransformData <- TSEVA_data[[2]]
nonStationaryEvaParams <- TSEVA_data[[1]]
trans='ori'
ExRange= c(min(nonStationaryEvaParams$potObj$parameters$peaks),
max(nonStationaryEvaParams$potObj$parameters$peaks))
Y <- c(seq(min(ExRange),max(ExRange),length.out=700))
result = tsEvaPlotTransfToStatFromAnalysisObj (nonStationaryEvaParams,
stationaryTransformData)
result
}
\seealso{
\code{\link{tsEvaPlotTransfToStat}}
}
