% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{tsEvaPlotGEVImageScFromAnalysisObj}
\alias{tsEvaPlotGEVImageScFromAnalysisObj}
\title{tsEvaPlotGEVImageScFromAnalysisObj}
\usage{
tsEvaPlotGEVImageScFromAnalysisObj(
  Y,
  nonStationaryEvaParams,
  stationaryTransformData,
  trans,
  ...
)
}
\arguments{
\item{Y}{The input data.}

\item{nonStationaryEvaParams}{A list of non-stationary evaluation parameters.}

\item{stationaryTransformData}{The stationary transform data.}

\item{trans}{The transformation method.}

\item{...}{Additional arguments.}
}
\value{
The GEV image scatter plot.
}
\description{
\code{tsEvaPlotGEVImageScFromAnalysisObj}is a function that generates a GEV
(Generalized Extreme Value) time-varying distribution through time as
and show the evolution of exceedance probabilities.
}
\examples{
 # Example usage of TsEvaNs function
timeAndSeries <- ArdecheStMartin
#go from six-hourly values to daily max
timeAndSeries <- max_daily_value(timeAndSeries)
#keep only the 20 last years
yrs <- as.integer(format(timeAndSeries$date, "\%Y"))
tokeep <- which(yrs>=2000)
timeAndSeries <- timeAndSeries[tokeep,]
timeWindow <- 5*365 # 10 years
TSEVA_data <- TsEvaNs(timeAndSeries, timeWindow,
transfType = 'trendPeaks',tail = 'high')

# Define the required function arguments
stationaryTransformData <- TSEVA_data[[2]]
nonStationaryEvaParams <- TSEVA_data[[1]]
trans='ori'

ExRange= c(min(nonStationaryEvaParams$potObj$parameters$peaks),
max(nonStationaryEvaParams$potObj$parameters$peaks))
Y <- c(seq(min(ExRange),max(ExRange),length.out=700))

result = tsEvaPlotGEVImageScFromAnalysisObj(Y,nonStationaryEvaParams,
stationaryTransformData, trans)
result
}
\seealso{
\code{\link{tsEvaPlotGEVImageSc}}
}
