% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva_functions.R
\name{tsEvaComputeReturnLevelsGEV}
\alias{tsEvaComputeReturnLevelsGEV}
\title{tsEvaComputeReturnLevelsGEV}
\usage{
tsEvaComputeReturnLevelsGEV(
  epsilon,
  sigma,
  mu,
  epsilonStdErr,
  sigmaStdErr,
  muStdErr,
  returnPeriodsInDts
)
}
\arguments{
\item{epsilon}{The shape parameter of the GEV distribution.}

\item{sigma}{The scale parameter of the GEV distribution.}

\item{mu}{The location parameter of the GEV distribution.}

\item{epsilonStdErr}{The standard error of the shape parameter.}

\item{sigmaStdErr}{The standard error of the scale parameter.}

\item{muStdErr}{The standard error of the location parameter.}

\item{returnPeriodsInDts}{The return periods expressed in the
corresponding time unit. For example, while working on yearly}
}
\value{
A list containing the following components:
\describe{
\item{\code{returnLevels}}{A matrix of return levels corresponding to the specified return periods.}
\item{\code{returnLevelsErr}}{A matrix of standard errors for the return levels.}
}
}
\description{
\code{tsEvaComputeReturnPeriodsGPD}is a function that calculates the return
levels for a Generalized Extreme Value (GEV) distribution given the GEV
parameters and their standard errors. The return periods are specified in a
time unit that corresponds to the size of the time segments for
evaluating the maxima.
}
\examples{
# Example usage with some sample data
epsilon <- c(0.1)
sigma <- c(2.3)
mu <- c(1.3)
epsilonStdErr <- c(0.01)
sigmaStdErr <- c(0.11)
muStdErr <- c(0.011)
returnPeriodsInDts <- c( 5, 10, 20, 50)
results <- tsEvaComputeReturnLevelsGEV(epsilon, sigma, mu, epsilonStdErr,
sigmaStdErr, muStdErr, returnPeriodsInDts)
head(results$returnLevels)
head(results$returnLevelsErr)
}
\seealso{
\code{\link{empdis}}
}
