% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{occ_gbif}
\alias{occ_gbif}
\title{Occurrence records of \emph{Araucaria angustifolia} from GBIF}
\format{
A data frame containing georeferenced GBIF occurrence records for
\emph{A. angustifolia} after all cleaning steps.
}
\usage{
occ_gbif
}
\description{
A cleaned dataset of occurrence records for \emph{Araucaria angustifolia} (Parana
pine) retrieved from GBIF.

Records were downloaded using the package’s GBIF workflow
(\code{prepare_gbif_download()}, \code{request_gbif()}, \code{import_gbif()}), and then
cleaned using the internal flagging workflow (duplicate detection and
removal).
}
\examples{
# Preview dataset
head(occ_gbif)

# Number of cleaned records
nrow(occ_gbif)

}
\seealso{
\code{prepare_gbif_download()}, \code{request_gbif()}, \code{import_gbif()},
\code{flag_duplicates()}, \code{remove_flagged()}
}
\keyword{datasets}
