% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_env_bg.R
\name{get_env_bg}
\alias{get_env_bg}
\title{Extract background data for SDM fitting.}
\usage{
get_env_bg(
  coords,
  env,
  method = "buffer",
  width = NULL,
  constraint_regions = NULL,
  standardize = TRUE
)
}
\arguments{
\item{coords}{Coordinates (long,lat) to extract values for}

\item{env}{Environmental SpatRaster(s) in any projection}

\item{method}{Methods for getting bg points. Current option is buffer}

\item{width}{Numeric or NULL.  Width (meters or map units) of buffer. If NULL, uses max dist between nearest occurrences.}

\item{constraint_regions}{An optional spatialpolygons* object that can be used to limit the selection of background points.}

\item{standardize}{Logical. If TRUE, the variables will be scaled and centered}
}
\value{
A list containing 1) the background data (env), 2) the cell indices for which the background was taken (buffer_cells), 3) the environmental means (env_mean; NA if standardization not done), and 4) the environmental standard deviations (env_sds; NA if standardization not done).
}
\description{
This function extracts background data around known presence records.
}
\note{
If supplying constraint_regions, any polygons in which the occurrences fall are considered fair game for background selection.
This background selection is, however, still limited by the buffer as well.
}
\examples{
{

# load in sample data

 library(S4DM)
 library(terra)

 # occurrence points
   data("sample_points")
   occurrences <- sample_points

 # environmental data
   env <- rast(system.file('ex/sample_env.tif', package="S4DM"))

 # rescale the environmental data

   env <- scale(env)

bg_data <- get_env_bg(coords = occurrences,
                      env = env,
                      method = "buffer",
                      width = 100000)


}
}
