% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/property.R
\name{new_property}
\alias{new_property}
\title{Define a new property}
\usage{
new_property(
  class = class_any,
  getter = NULL,
  setter = NULL,
  validator = NULL,
  default = NULL,
  name = NULL
)
}
\arguments{
\item{class}{Class that the property must be an instance of.
See \code{\link[=as_class]{as_class()}} for details.}

\item{getter}{An optional function used to get the value. The function
should take \code{self} as its sole argument and return the value. If you
supply a \code{getter}, you are responsible for ensuring that it returns
an object of the correct \code{class}; it will not be validated automatically.

If a property has a getter but doesn't have a setter, it is read only.}

\item{setter}{An optional function used to set the value. The function
should take \code{self} and \code{value} and return a modified object.}

\item{validator}{A function taking a single argument, \code{value}, the value
to validate.

The job of a validator is to determine whether the property value is valid.
It should return \code{NULL} if the object is valid, or if it's not valid,
a single string describing the problem. The message should not include the
name of the property as this will be automatically appended to the
beginning of the message.

The validator will be called after the \code{class} has been verified, so
your code can assume that \code{value} has known type.}

\item{default}{When an object is created and the property is not supplied,
what should it default to? If \code{NULL}, it defaults to the "empty" instance
of \code{class}. This can also be a quoted call, which then becomes a standard
function promise in the default constructor, evaluated at the time the
object is constructed.}

\item{name}{Property name, primarily used for error messages. Generally
don't need to set this here, as it's more convenient to supply as
the element name when defining a list of properties. If both \code{name}
and a list-name are supplied, the list-name will be used.}
}
\value{
An S7 property, i.e. a list with class \code{S7_property}.
}
\description{
A property defines a named component of an object. Properties are
typically used to store (meta) data about an object, and are often
limited to a data of a specific \code{class}.

By specifying a \code{getter} and/or \code{setter}, you can make the property
"dynamic" so that it's computed when accessed or has some non-standard
behaviour when modified. Dynamic properties are not included as an argument
to the default class constructor.

See the "Properties: Common Patterns" section in \code{vignette("class-objects")}
for more examples.
}
\examples{
# Simple properties store data inside an object
Pizza <- new_class("Pizza", properties = list(
  slices = new_property(class_numeric, default = 10)
))
my_pizza <- Pizza(slices = 6)
my_pizza@slices
my_pizza@slices <- 5
my_pizza@slices

your_pizza <- Pizza()
your_pizza@slices

# Dynamic properties can compute on demand
Clock <- new_class("Clock", properties = list(
  now = new_property(getter = function(self) Sys.time())
))
my_clock <- Clock()
my_clock@now; Sys.sleep(1)
my_clock@now
# This property is read only, because there is a 'getter' but not a 'setter'
try(my_clock@now <- 10)

# Because the property is dynamic, it is not included as an
# argument to the default constructor
try(Clock(now = 10))
args(Clock)
}
