% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sSizes}
\alias{sSizes}
\alias{sOpt}
\title{Optimal parameter s}
\usage{
sSizes(n, lower = 0.5, upper = 1, step = 0.1)

sOpt(n, s = 0.6)
}
\arguments{
\item{n}{Sample size(s), numeric (vector).}

\item{lower, upper}{lower and upper search border, between 0 and 1.}

\item{step}{size of the step for the search, between 0 and 1.}

\item{s}{Desired exponent, \eqn{0.5 \leq s \leq 1}.}
}
\value{
\code{sSizes} returns a data frame containing
\item{n}{the given sample size}
\item{s}{the exponent in question}
\item{ln}{the resulting block length}
\item{bn}{the corresponding number of block}
\item{ln.bn}{block length times number of blocks}
\item{diff}{difference between the given sample size and the number of observations covered by the blocks}

\code{sOpt} returns a numeric vector of the optimal exponent(s).
}
\description{
Calculates the best parameter \eqn{\tilde{s}} for a given approximation s, such that \eqn{n \; \% \; [n^{s}] = 0}.
}
\examples{
sSizes(50)
sSizes(50, 0.6, 0.8, 0.01)

sOpt(50, 0.6)
sOpt(100, 0.6)

}
