% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nybight.R
\docType{data}
\name{nybight}
\alias{nybight}
\title{nybight data}
\format{
This data frame contains the following columns:
\describe{
\item{year:}{year of data collection, 1974 or 1975}

\item{stratum:}{stratum membership, based on depth}

\item{catchnum:}{number of fish caught during trawl}

\item{catchwt:}{total weight (kg) of fish caught during trawl}

\item{numspp:}{number of species of fish caught during trawl}

\item{depth:}{depth of station (m)}

\item{temp:}{surface temperature (degrees \eqn{^{\circ}}C)}
}
}
\usage{
data(nybight)
}
\description{
Data collected in the New York Bight for June 1974 and June 1975. Two of the
original strata were combined because of insufficient sample sizes. For variable "catchwt",
weights less than 0.5 were recorded as 0.5 kg.
}
\details{
Missing values are coded as NA.
}
\references{
Wilk et al. (1977). Fishes and Associated
Environmental Data Collected in New York Bight, June 1974–June 1975. \emph{NOAA Tech.
Rep. No. NMFS SSRF-716.} Washington, DC: U.S. Government Printing Office.

Lohr (2021), Sampling: Design and Analysis, 3rd Edition. Boca Raton, FL: CRC Press.

Lu and Lohr (2021), R Companion for \emph{Sampling: Design and Analysis, 3rd Edition}, 1st Edition. Boca Raton, FL: CRC Press.
}
\keyword{datasets}
