% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readData.R
\name{read.dataset}
\alias{read.dataset}
\title{Reads a KEEL, ARFF or CSV data format file.}
\usage{
read.dataset(file, sep = ",", quote = "\\"", dec = ".", na.strings = "?")
}
\arguments{
\item{file}{The path of the file to read}

\item{sep}{The separator character to use}

\item{quote}{The character used to take quotes}

\item{dec}{The character used to define decimal characters}

\item{na.strings}{The character to detect lost data}
}
\description{
This function reads a KEEL (.dat), ARFF (.arff) or CSV dataset file and store the information
  in a \code{SDEFSR_Dataset} class.
}
\details{
A KEEL data file must have the following structure:
 \itemize{
   \item{ @relation: Name of the data set }
   \item{ @attribute: Description of an attribute (one for each attribute)}
   \item{ @inputs: List with the names of the input attributes }
   \item{ @output: Name of the output attribute (Not used in this algorithms implementation) }
   \item{ @data: Starting tag of the data}
}
   The rest of the file contains all the examples belonging to the data set, expressed in comma sepparated values format.
   ARFF file format is a well-know dataset format from WEKA data mining tool.
   CSV is a format which means comma-separated values. Where each examples is on a line and each value of the variables of the examples
   are separated by commas.
}
\examples{
    \dontrun{
       Reads a KEEL dataset from a file.
       read.dataset(file = "C:\KEELFile.dat")

       read.dataset(file = "C:\KEELFile.dat", nLabels = 7)
       
     Reads an ARFF dataset from a file.
       read.dataset(file = "C:\ARFFFile.arff")

       read.dataset(file = "C:\ARFFFile.arff", nLabels = 7)
    }
    
}
\references{
J. Alcala-Fdez, A. Fernandez, J. Luengo, J. Derrac, S. Garcia, L. Sanchez, F. Herrera. KEEL Data-Mining Software Tool: Data Set Repository, Integration of Algorithms and Experimental Analysis Framework. Journal of Multiple-Valued Logic and Soft Computing 17:2-3 (2011) 255-287.
}
\seealso{
KEEL Dataset Repository (Standard Classification): \url{https://sci2s.ugr.es/keel/category.php?cat=clas}
}
\author{
Angel M. Garcia <agvico@ujaen.es>
}
