% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.R
\name{predict_forest}
\alias{predict_forest}
\title{Predict SFHNV random forest point estimates}
\usage{
predict_forest(forest, observations, trim_prop = 0.05, parallel = TRUE)
}
\arguments{
\item{forest}{A list of trees produced by \code{\link[=build_random_forest]{build_random_forest()}}.}

\item{observations}{Data frame of new observations.}

\item{trim_prop}{Optional trimming proportion used in the robust aggregation.}

\item{parallel}{Logical; if \code{TRUE} and \code{future.apply} is available, predict in parallel.}
}
\value{
Numeric vector of aggregated predictions.
}
\description{
Predict SFHNV random forest point estimates
}
\examples{
data <- data.frame(x1 = rnorm(100), x2 = rnorm(100), D = rnorm(100), Q = rnorm(100))
forest <- build_random_forest(data, num_trees = 3, min_size = 15)
predict_forest(forest, data)
}
