% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/componentCVPatterns.R
\name{componentCVPatterns}
\alias{componentCVPatterns}
\title{Cross-Validation of Simplivariate Component Patterns}
\usage{
componentCVPatterns(
  df,
  rows,
  cols,
  patternFunctions,
  patternFitters,
  preferenceOrder = names(patternFunctions),
  nRepeats = 40,
  testFraction = 0.2,
  minCellsForModels = 25,
  parsimonyMargin = 0.05,
  requireFitters = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{df}{A matrix or data frame containing the data}

\item{rows}{Row indices to subset from df}

\item{cols}{Column indices to subset from df}

\item{patternFunctions}{A named list of pattern functions to evaluate}

\item{patternFitters}{A named list of fitter functions corresponding to each pattern}

\item{preferenceOrder}{Character vector specifying the preference order of patterns (default: names of patternFunctions)}

\item{nRepeats}{Integer, number of cross-validation repeats (default: 40)}

\item{testFraction}{Numeric, fraction of data to use for testing in each CV fold (default: 0.2)}

\item{minCellsForModels}{Integer, minimum number of cells required for reliable CV (default: 25)}

\item{parsimonyMargin}{Numeric, margin for parsimony selection as fraction (default: 0.05)}

\item{requireFitters}{Logical, whether to require fitters for all patterns (default: TRUE)}

\item{verbose}{Logical, whether to print progress messages (default: FALSE)}
}
\value{
A list containing:
\item{decision}{Character, the selected best pattern name}
\item{reason}{Character, explanation of the selection reasoning}
\item{cv}{Data frame with CV summary statistics for each model}
\item{repeats}{Data frame with detailed results from each CV repeat}
\item{meta}{List with metadata about the CV procedure}
}
\description{
Performs pure cross-validation over specified patterns with mandatory fitters.
This function evaluates different pattern fitting models using cross-validation
to determine the best model for a given data subset.
}
